# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateKamReleaseDetails(object):
    """
    Details of an upgrade request
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateKamReleaseDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kam_chart_id:
            The value to assign to the kam_chart_id property of this UpdateKamReleaseDetails.
        :type kam_chart_id: str

        :param overrides:
            The value to assign to the overrides property of this UpdateKamReleaseDetails.
        :type overrides: list[KamOverride]

        """
        self.swagger_types = {
            'kam_chart_id': 'str',
            'overrides': 'list[KamOverride]'
        }

        self.attribute_map = {
            'kam_chart_id': 'kamChartId',
            'overrides': 'overrides'
        }

        self._kam_chart_id = None
        self._overrides = None

    @property
    def kam_chart_id(self):
        """
        **[Required]** Gets the kam_chart_id of this UpdateKamReleaseDetails.
        The OCID of the OKE Add-on or Marketplace app to deploy


        :return: The kam_chart_id of this UpdateKamReleaseDetails.
        :rtype: str
        """
        return self._kam_chart_id

    @kam_chart_id.setter
    def kam_chart_id(self, kam_chart_id):
        """
        Sets the kam_chart_id of this UpdateKamReleaseDetails.
        The OCID of the OKE Add-on or Marketplace app to deploy


        :param kam_chart_id: The kam_chart_id of this UpdateKamReleaseDetails.
        :type: str
        """
        self._kam_chart_id = kam_chart_id

    @property
    def overrides(self):
        """
        Gets the overrides of this UpdateKamReleaseDetails.
        List of overrides for default configuration


        :return: The overrides of this UpdateKamReleaseDetails.
        :rtype: list[KamOverride]
        """
        return self._overrides

    @overrides.setter
    def overrides(self, overrides):
        """
        Sets the overrides of this UpdateKamReleaseDetails.
        List of overrides for default configuration


        :param overrides: The overrides of this UpdateKamReleaseDetails.
        :type: list[KamOverride]
        """
        self._overrides = overrides

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
