# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from .backup_location import BackupLocation
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BackupLocationBucket(BackupLocation):
    """
    Object storage bucket details to upload or download the backup
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BackupLocationBucket object with values from keyword arguments. The default value of the :py:attr:`~oci.key_management.models.BackupLocationBucket.destination` attribute
        of this class is ``BUCKET`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param destination:
            The value to assign to the destination property of this BackupLocationBucket.
            Allowed values for this property are: "BUCKET", "PRE_AUTHENTICATED_REQUEST_URI"
        :type destination: str

        :param compartment_id:
            The value to assign to the compartment_id property of this BackupLocationBucket.
        :type compartment_id: str

        :param name:
            The value to assign to the name property of this BackupLocationBucket.
        :type name: str

        """
        self.swagger_types = {
            'destination': 'str',
            'compartment_id': 'str',
            'name': 'str'
        }

        self.attribute_map = {
            'destination': 'destination',
            'compartment_id': 'compartmentId',
            'name': 'name'
        }

        self._destination = None
        self._compartment_id = None
        self._name = None
        self._destination = 'BUCKET'

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this BackupLocationBucket.

        :return: The compartment_id of this BackupLocationBucket.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this BackupLocationBucket.

        :param compartment_id: The compartment_id of this BackupLocationBucket.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this BackupLocationBucket.

        :return: The name of this BackupLocationBucket.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this BackupLocationBucket.

        :param name: The name of this BackupLocationBucket.
        :type: str
        """
        self._name = name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
