# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from __future__ import absolute_import

from .ad_fd import AdFd
from .analytics_cluster import AnalyticsCluster
from .analytics_cluster_memory_estimates import AnalyticsClusterMemoryEstimates
from .analytics_cluster_node import AnalyticsClusterNode
from .analytics_cluster_shape_summary import AnalyticsClusterShapeSummary
from .analytics_cluster_summary import AnalyticsClusterSummary
from .analytics_cluster_table_memory_estimate import AnalyticsClusterTableMemoryEstimate
from .backup import Backup
from .backup_invocation_details import BackupInvocationDetails
from .backup_policy import BackupPolicy
from .backup_summary import BackupSummary
from .clone_or_restore_from_backup_details import CloneOrRestoreFromBackupDetails
from .configuration import Configuration
from .configuration_revision import ConfigurationRevision
from .configuration_revision_summary import ConfigurationRevisionSummary
from .configuration_summary import ConfigurationSummary
from .copy_configuration_details import CopyConfigurationDetails
from .create_analytics_cluster_details import CreateAnalyticsClusterDetails
from .create_configuration_details import CreateConfigurationDetails
from .create_db_system_details import CreateDbSystemDetails
from .create_in_bound_channel_details import CreateInBoundChannelDetails
from .create_instance_details import CreateInstanceDetails
from .create_update_backup_policy import CreateUpdateBackupPolicy
from .db_system import DbSystem
from .db_system_availability_policy import DbSystemAvailabilityPolicy
from .db_system_endpoint import DbSystemEndpoint
from .db_system_instance import DbSystemInstance
from .db_system_summary import DbSystemSummary
from .in_bound_channel import InBoundChannel
from .instance import Instance
from .instance_db_system_role import InstanceDbSystemRole
from .instance_summary import InstanceSummary
from .mysqlaas_instance_limits_check import MysqlaasInstanceLimitsCheck
from .option import Option
from .option_metadata import OptionMetadata
from .option_metadata_value import OptionMetadataValue
from .restart_instance_details import RestartInstanceDetails
from .shape_summary import ShapeSummary
from .stop_instance_details import StopInstanceDetails
from .table_schema import TableSchema
from .update_analytics_cluster_details import UpdateAnalyticsClusterDetails
from .update_backup_details import UpdateBackupDetails
from .update_configuration_details import UpdateConfigurationDetails
from .update_db_system_details import UpdateDbSystemDetails
from .update_instance_details import UpdateInstanceDetails
from .version import Version
from .version_options_metadata import VersionOptionsMetadata
from .version_summary import VersionSummary
from .work_request import WorkRequest
from .work_request_error import WorkRequestError
from .work_request_log_entry import WorkRequestLogEntry
from .work_request_resource import WorkRequestResource
from .work_request_summary import WorkRequestSummary

# Maps type names to classes for mysql services.
mysql_type_mapping = {
    "AdFd": AdFd,
    "AnalyticsCluster": AnalyticsCluster,
    "AnalyticsClusterMemoryEstimates": AnalyticsClusterMemoryEstimates,
    "AnalyticsClusterNode": AnalyticsClusterNode,
    "AnalyticsClusterShapeSummary": AnalyticsClusterShapeSummary,
    "AnalyticsClusterSummary": AnalyticsClusterSummary,
    "AnalyticsClusterTableMemoryEstimate": AnalyticsClusterTableMemoryEstimate,
    "Backup": Backup,
    "BackupInvocationDetails": BackupInvocationDetails,
    "BackupPolicy": BackupPolicy,
    "BackupSummary": BackupSummary,
    "CloneOrRestoreFromBackupDetails": CloneOrRestoreFromBackupDetails,
    "Configuration": Configuration,
    "ConfigurationRevision": ConfigurationRevision,
    "ConfigurationRevisionSummary": ConfigurationRevisionSummary,
    "ConfigurationSummary": ConfigurationSummary,
    "CopyConfigurationDetails": CopyConfigurationDetails,
    "CreateAnalyticsClusterDetails": CreateAnalyticsClusterDetails,
    "CreateConfigurationDetails": CreateConfigurationDetails,
    "CreateDbSystemDetails": CreateDbSystemDetails,
    "CreateInBoundChannelDetails": CreateInBoundChannelDetails,
    "CreateInstanceDetails": CreateInstanceDetails,
    "CreateUpdateBackupPolicy": CreateUpdateBackupPolicy,
    "DbSystem": DbSystem,
    "DbSystemAvailabilityPolicy": DbSystemAvailabilityPolicy,
    "DbSystemEndpoint": DbSystemEndpoint,
    "DbSystemInstance": DbSystemInstance,
    "DbSystemSummary": DbSystemSummary,
    "InBoundChannel": InBoundChannel,
    "Instance": Instance,
    "InstanceDbSystemRole": InstanceDbSystemRole,
    "InstanceSummary": InstanceSummary,
    "MysqlaasInstanceLimitsCheck": MysqlaasInstanceLimitsCheck,
    "Option": Option,
    "OptionMetadata": OptionMetadata,
    "OptionMetadataValue": OptionMetadataValue,
    "RestartInstanceDetails": RestartInstanceDetails,
    "ShapeSummary": ShapeSummary,
    "StopInstanceDetails": StopInstanceDetails,
    "TableSchema": TableSchema,
    "UpdateAnalyticsClusterDetails": UpdateAnalyticsClusterDetails,
    "UpdateBackupDetails": UpdateBackupDetails,
    "UpdateConfigurationDetails": UpdateConfigurationDetails,
    "UpdateDbSystemDetails": UpdateDbSystemDetails,
    "UpdateInstanceDetails": UpdateInstanceDetails,
    "Version": Version,
    "VersionOptionsMetadata": VersionOptionsMetadata,
    "VersionSummary": VersionSummary,
    "WorkRequest": WorkRequest,
    "WorkRequestError": WorkRequestError,
    "WorkRequestLogEntry": WorkRequestLogEntry,
    "WorkRequestResource": WorkRequestResource,
    "WorkRequestSummary": WorkRequestSummary
}
