# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AnalyticsCluster(object):
    """
    AnalyticsCluster model.
    """

    #: A constant which can be used with the lifecycle_state property of a AnalyticsCluster.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a AnalyticsCluster.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a AnalyticsCluster.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a AnalyticsCluster.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a AnalyticsCluster.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a AnalyticsCluster.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a AnalyticsCluster.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new AnalyticsCluster object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AnalyticsCluster.
        :type id: str

        :param description:
            The value to assign to the description property of this AnalyticsCluster.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this AnalyticsCluster.
        :type compartment_id: str

        :param instance_id:
            The value to assign to the instance_id property of this AnalyticsCluster.
        :type instance_id: str

        :param instance:
            The value to assign to the instance property of this AnalyticsCluster.
        :type instance: InstanceSummary

        :param shape_name:
            The value to assign to the shape_name property of this AnalyticsCluster.
        :type shape_name: str

        :param cluster_size:
            The value to assign to the cluster_size property of this AnalyticsCluster.
        :type cluster_size: int

        :param cluster_nodes:
            The value to assign to the cluster_nodes property of this AnalyticsCluster.
        :type cluster_nodes: list[AnalyticsClusterNode]

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this AnalyticsCluster.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this AnalyticsCluster.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this AnalyticsCluster.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this AnalyticsCluster.
        :type time_updated: datetime

        :param host_image_id:
            The value to assign to the host_image_id property of this AnalyticsCluster.
        :type host_image_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this AnalyticsCluster.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this AnalyticsCluster.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'instance_id': 'str',
            'instance': 'InstanceSummary',
            'shape_name': 'str',
            'cluster_size': 'int',
            'cluster_nodes': 'list[AnalyticsClusterNode]',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'host_image_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'instance_id': 'instanceId',
            'instance': 'instance',
            'shape_name': 'shapeName',
            'cluster_size': 'clusterSize',
            'cluster_nodes': 'clusterNodes',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'host_image_id': 'hostImageId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._description = None
        self._compartment_id = None
        self._instance_id = None
        self._instance = None
        self._shape_name = None
        self._cluster_size = None
        self._cluster_nodes = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._host_image_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this AnalyticsCluster.
        The OCID of the MySQLaaS Analytics Cluster.


        :return: The id of this AnalyticsCluster.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AnalyticsCluster.
        The OCID of the MySQLaaS Analytics Cluster.


        :param id: The id of this AnalyticsCluster.
        :type: str
        """
        self._id = id

    @property
    def description(self):
        """
        Gets the description of this AnalyticsCluster.
        User-provided data about the MySQLaaS Instance.


        :return: The description of this AnalyticsCluster.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AnalyticsCluster.
        User-provided data about the MySQLaaS Instance.


        :param description: The description of this AnalyticsCluster.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AnalyticsCluster.
        OCID of the Compartment the MySQLaaS Analytics Cluster exists in.


        :return: The compartment_id of this AnalyticsCluster.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AnalyticsCluster.
        OCID of the Compartment the MySQLaaS Analytics Cluster exists in.


        :param compartment_id: The compartment_id of this AnalyticsCluster.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this AnalyticsCluster.
        The OCID of the MySQLaaS Instance this MySQLaaS Analytics Cluster is attached to.


        :return: The instance_id of this AnalyticsCluster.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this AnalyticsCluster.
        The OCID of the MySQLaaS Instance this MySQLaaS Analytics Cluster is attached to.


        :param instance_id: The instance_id of this AnalyticsCluster.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def instance(self):
        """
        Gets the instance of this AnalyticsCluster.

        :return: The instance of this AnalyticsCluster.
        :rtype: InstanceSummary
        """
        return self._instance

    @instance.setter
    def instance(self, instance):
        """
        Sets the instance of this AnalyticsCluster.

        :param instance: The instance of this AnalyticsCluster.
        :type: InstanceSummary
        """
        self._instance = instance

    @property
    def shape_name(self):
        """
        **[Required]** Gets the shape_name of this AnalyticsCluster.
        The shape determines resources to allocate to the MySQLaaS Analyics
        Cluster nodes - CPU cores, memory.


        :return: The shape_name of this AnalyticsCluster.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this AnalyticsCluster.
        The shape determines resources to allocate to the MySQLaaS Analyics
        Cluster nodes - CPU cores, memory.


        :param shape_name: The shape_name of this AnalyticsCluster.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def cluster_size(self):
        """
        **[Required]** Gets the cluster_size of this AnalyticsCluster.
        The number of Analytics-processing compute instances, of the
        specified shape, in the Analytics Cluster.


        :return: The cluster_size of this AnalyticsCluster.
        :rtype: int
        """
        return self._cluster_size

    @cluster_size.setter
    def cluster_size(self, cluster_size):
        """
        Sets the cluster_size of this AnalyticsCluster.
        The number of Analytics-processing compute instances, of the
        specified shape, in the Analytics Cluster.


        :param cluster_size: The cluster_size of this AnalyticsCluster.
        :type: int
        """
        self._cluster_size = cluster_size

    @property
    def cluster_nodes(self):
        """
        **[Required]** Gets the cluster_nodes of this AnalyticsCluster.

        :return: The cluster_nodes of this AnalyticsCluster.
        :rtype: list[AnalyticsClusterNode]
        """
        return self._cluster_nodes

    @cluster_nodes.setter
    def cluster_nodes(self, cluster_nodes):
        """
        Sets the cluster_nodes of this AnalyticsCluster.

        :param cluster_nodes: The cluster_nodes of this AnalyticsCluster.
        :type: list[AnalyticsClusterNode]
        """
        self._cluster_nodes = cluster_nodes

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this AnalyticsCluster.
        The current state of the MySQLaaS Analytics Cluster.

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this AnalyticsCluster.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this AnalyticsCluster.
        The current state of the MySQLaaS Analytics Cluster.


        :param lifecycle_state: The lifecycle_state of this AnalyticsCluster.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this AnalyticsCluster.
        Additional information about the current lifecycleState.


        :return: The lifecycle_details of this AnalyticsCluster.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this AnalyticsCluster.
        Additional information about the current lifecycleState.


        :param lifecycle_details: The lifecycle_details of this AnalyticsCluster.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this AnalyticsCluster.
        The date and time the MySQLaaS Analytics Cluster was created, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this AnalyticsCluster.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this AnalyticsCluster.
        The date and time the MySQLaaS Analytics Cluster was created, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this AnalyticsCluster.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this AnalyticsCluster.
        The time the Analytics Cluster was last updated, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_updated of this AnalyticsCluster.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this AnalyticsCluster.
        The time the Analytics Cluster was last updated, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_updated: The time_updated of this AnalyticsCluster.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def host_image_id(self):
        """
        Gets the host_image_id of this AnalyticsCluster.
        [PRIVATE API] OCID of the host image used for this Analytics Cluster. If not set, the control plane default will be used.


        :return: The host_image_id of this AnalyticsCluster.
        :rtype: str
        """
        return self._host_image_id

    @host_image_id.setter
    def host_image_id(self, host_image_id):
        """
        Sets the host_image_id of this AnalyticsCluster.
        [PRIVATE API] OCID of the host image used for this Analytics Cluster. If not set, the control plane default will be used.


        :param host_image_id: The host_image_id of this AnalyticsCluster.
        :type: str
        """
        self._host_image_id = host_image_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this AnalyticsCluster.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this AnalyticsCluster.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this AnalyticsCluster.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this AnalyticsCluster.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this AnalyticsCluster.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this AnalyticsCluster.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this AnalyticsCluster.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this AnalyticsCluster.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
