# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AnalyticsClusterMemoryEstimates(object):
    """
    Returns the OCID of the MySQLaaS Instance with the most recent Analytics Cluster memory estimate
    that can be used to provision the Analytics Cluster size. For each MySQL user table the estimated memory
    footprint when the table is loaded to the Analytics Cluster memory is returned.
    """

    #: A constant which can be used with the status property of a AnalyticsClusterMemoryEstimates.
    #: This constant has a value of "ACCEPTED"
    STATUS_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the status property of a AnalyticsClusterMemoryEstimates.
    #: This constant has a value of "IN_PROGRESS"
    STATUS_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the status property of a AnalyticsClusterMemoryEstimates.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    #: A constant which can be used with the status property of a AnalyticsClusterMemoryEstimates.
    #: This constant has a value of "SUCCEEDED"
    STATUS_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the status property of a AnalyticsClusterMemoryEstimates.
    #: This constant has a value of "CANCELING"
    STATUS_CANCELING = "CANCELING"

    #: A constant which can be used with the status property of a AnalyticsClusterMemoryEstimates.
    #: This constant has a value of "CANCELED"
    STATUS_CANCELED = "CANCELED"

    def __init__(self, **kwargs):
        """
        Initializes a new AnalyticsClusterMemoryEstimates object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this AnalyticsClusterMemoryEstimates.
        :type instance_id: str

        :param status:
            The value to assign to the status property of this AnalyticsClusterMemoryEstimates.
            Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param time_created:
            The value to assign to the time_created property of this AnalyticsClusterMemoryEstimates.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this AnalyticsClusterMemoryEstimates.
        :type time_updated: datetime

        :param table_schemas:
            The value to assign to the table_schemas property of this AnalyticsClusterMemoryEstimates.
        :type table_schemas: list[TableSchema]

        """
        self.swagger_types = {
            'instance_id': 'str',
            'status': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'table_schemas': 'list[TableSchema]'
        }

        self.attribute_map = {
            'instance_id': 'instanceId',
            'status': 'status',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'table_schemas': 'tableSchemas'
        }

        self._instance_id = None
        self._status = None
        self._time_created = None
        self._time_updated = None
        self._table_schemas = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this AnalyticsClusterMemoryEstimates.
        The OCID of the MySQLaaS Instance that was used to estimate the memory footprints.


        :return: The instance_id of this AnalyticsClusterMemoryEstimates.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this AnalyticsClusterMemoryEstimates.
        The OCID of the MySQLaaS Instance that was used to estimate the memory footprints.


        :param instance_id: The instance_id of this AnalyticsClusterMemoryEstimates.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def status(self):
        """
        **[Required]** Gets the status of this AnalyticsClusterMemoryEstimates.
        Current status of the Work Request generating the estimate.

        Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this AnalyticsClusterMemoryEstimates.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this AnalyticsClusterMemoryEstimates.
        Current status of the Work Request generating the estimate.


        :param status: The status of this AnalyticsClusterMemoryEstimates.
        :type: str
        """
        allowed_values = ["ACCEPTED", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this AnalyticsClusterMemoryEstimates.
        The date and time that the Work Request for the estimate was issued, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc333


        :return: The time_created of this AnalyticsClusterMemoryEstimates.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this AnalyticsClusterMemoryEstimates.
        The date and time that the Work Request for the estimate was issued, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc333


        :param time_created: The time_created of this AnalyticsClusterMemoryEstimates.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this AnalyticsClusterMemoryEstimates.
        The date and time that the estimate was generated, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc333


        :return: The time_updated of this AnalyticsClusterMemoryEstimates.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this AnalyticsClusterMemoryEstimates.
        The date and time that the estimate was generated, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc333


        :param time_updated: The time_updated of this AnalyticsClusterMemoryEstimates.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def table_schemas(self):
        """
        **[Required]** Gets the table_schemas of this AnalyticsClusterMemoryEstimates.
        Collection of schemas with estimated memory footprints for MySQL user tables of each schema
        when loaded to Analytics Cluster memory.


        :return: The table_schemas of this AnalyticsClusterMemoryEstimates.
        :rtype: list[TableSchema]
        """
        return self._table_schemas

    @table_schemas.setter
    def table_schemas(self, table_schemas):
        """
        Sets the table_schemas of this AnalyticsClusterMemoryEstimates.
        Collection of schemas with estimated memory footprints for MySQL user tables of each schema
        when loaded to Analytics Cluster memory.


        :param table_schemas: The table_schemas of this AnalyticsClusterMemoryEstimates.
        :type: list[TableSchema]
        """
        self._table_schemas = table_schemas

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
