# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AnalyticsClusterShapeSummary(object):
    """
    The shape of the MySQLaaS Analytics Cluster. The shape determines
    resources to allocate to each node in the MySQLaaS Analytics Cluster.
    For a description of shapes, see `MySQLaaS Analytics Cluster Create
    Options`__.  To
    use any of the API operations, you must be authorized in an IAM
    policy. If you are not authorized, talk to an administrator.  If you are
    an administrator who needs to write policies to give users access, see
    `Getting Started with
    Policies`__.

    __ https://docs.cloud.oracle.com/Content/MySQL/References/MySqlAnalyticslaunchoptions.htm
    __ https://docs.cloud.oracle.com/Content/Identity/Concepts/policygetstarted.htm
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AnalyticsClusterShapeSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this AnalyticsClusterShapeSummary.
        :type name: str

        :param cpu_core_count:
            The value to assign to the cpu_core_count property of this AnalyticsClusterShapeSummary.
        :type cpu_core_count: int

        :param memory_size_in_gbs:
            The value to assign to the memory_size_in_gbs property of this AnalyticsClusterShapeSummary.
        :type memory_size_in_gbs: int

        """
        self.swagger_types = {
            'name': 'str',
            'cpu_core_count': 'int',
            'memory_size_in_gbs': 'int'
        }

        self.attribute_map = {
            'name': 'name',
            'cpu_core_count': 'cpuCoreCount',
            'memory_size_in_gbs': 'memorySizeInGBs'
        }

        self._name = None
        self._cpu_core_count = None
        self._memory_size_in_gbs = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this AnalyticsClusterShapeSummary.
        The name of the shape used for each compute node in MySQLaaS Analytics Cluster.


        :return: The name of this AnalyticsClusterShapeSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AnalyticsClusterShapeSummary.
        The name of the shape used for each compute node in MySQLaaS Analytics Cluster.


        :param name: The name of this AnalyticsClusterShapeSummary.
        :type: str
        """
        self._name = name

    @property
    def cpu_core_count(self):
        """
        **[Required]** Gets the cpu_core_count of this AnalyticsClusterShapeSummary.
        The number of CPU Cores the Instance provides. These are \"OCPU\"s.


        :return: The cpu_core_count of this AnalyticsClusterShapeSummary.
        :rtype: int
        """
        return self._cpu_core_count

    @cpu_core_count.setter
    def cpu_core_count(self, cpu_core_count):
        """
        Sets the cpu_core_count of this AnalyticsClusterShapeSummary.
        The number of CPU Cores the Instance provides. These are \"OCPU\"s.


        :param cpu_core_count: The cpu_core_count of this AnalyticsClusterShapeSummary.
        :type: int
        """
        self._cpu_core_count = cpu_core_count

    @property
    def memory_size_in_gbs(self):
        """
        **[Required]** Gets the memory_size_in_gbs of this AnalyticsClusterShapeSummary.
        The amount of RAM the Instance provides. This is an IEC base-2 number.


        :return: The memory_size_in_gbs of this AnalyticsClusterShapeSummary.
        :rtype: int
        """
        return self._memory_size_in_gbs

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, memory_size_in_gbs):
        """
        Sets the memory_size_in_gbs of this AnalyticsClusterShapeSummary.
        The amount of RAM the Instance provides. This is an IEC base-2 number.


        :param memory_size_in_gbs: The memory_size_in_gbs of this AnalyticsClusterShapeSummary.
        :type: int
        """
        self._memory_size_in_gbs = memory_size_in_gbs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
