# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BackupInvocationDetails(object):
    """
    Parameters for a manually-invoked backup.
    """

    #: A constant which can be used with the backup_type property of a BackupInvocationDetails.
    #: This constant has a value of "FULL"
    BACKUP_TYPE_FULL = "FULL"

    #: A constant which can be used with the backup_type property of a BackupInvocationDetails.
    #: This constant has a value of "INCREMENTAL"
    BACKUP_TYPE_INCREMENTAL = "INCREMENTAL"

    def __init__(self, **kwargs):
        """
        Initializes a new BackupInvocationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param backup_type:
            The value to assign to the backup_type property of this BackupInvocationDetails.
            Allowed values for this property are: "FULL", "INCREMENTAL"
        :type backup_type: str

        :param display_name:
            The value to assign to the display_name property of this BackupInvocationDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this BackupInvocationDetails.
        :type description: str

        :param retention_days:
            The value to assign to the retention_days property of this BackupInvocationDetails.
        :type retention_days: int

        :param freeform_tags:
            The value to assign to the freeform_tags property of this BackupInvocationDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this BackupInvocationDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'backup_type': 'str',
            'display_name': 'str',
            'description': 'str',
            'retention_days': 'int',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'backup_type': 'backupType',
            'display_name': 'displayName',
            'description': 'description',
            'retention_days': 'retentionDays',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._backup_type = None
        self._display_name = None
        self._description = None
        self._retention_days = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def backup_type(self):
        """
        **[Required]** Gets the backup_type of this BackupInvocationDetails.
        What type of backup to take.

        Allowed values for this property are: "FULL", "INCREMENTAL"


        :return: The backup_type of this BackupInvocationDetails.
        :rtype: str
        """
        return self._backup_type

    @backup_type.setter
    def backup_type(self, backup_type):
        """
        Sets the backup_type of this BackupInvocationDetails.
        What type of backup to take.


        :param backup_type: The backup_type of this BackupInvocationDetails.
        :type: str
        """
        allowed_values = ["FULL", "INCREMENTAL"]
        if not value_allowed_none_or_none_sentinel(backup_type, allowed_values):
            raise ValueError(
                "Invalid value for `backup_type`, must be None or one of {0}"
                .format(allowed_values)
            )
        self._backup_type = backup_type

    @property
    def display_name(self):
        """
        Gets the display_name of this BackupInvocationDetails.
        A user-supplied display name for the backup.


        :return: The display_name of this BackupInvocationDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this BackupInvocationDetails.
        A user-supplied display name for the backup.


        :param display_name: The display_name of this BackupInvocationDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this BackupInvocationDetails.
        A user-supplied description for the backup.


        :return: The description of this BackupInvocationDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this BackupInvocationDetails.
        A user-supplied description for the backup.


        :param description: The description of this BackupInvocationDetails.
        :type: str
        """
        self._description = description

    @property
    def retention_days(self):
        """
        Gets the retention_days of this BackupInvocationDetails.
        Number of days to retain this manual backup.


        :return: The retention_days of this BackupInvocationDetails.
        :rtype: int
        """
        return self._retention_days

    @retention_days.setter
    def retention_days(self, retention_days):
        """
        Sets the retention_days of this BackupInvocationDetails.
        Number of days to retain this manual backup.


        :param retention_days: The retention_days of this BackupInvocationDetails.
        :type: int
        """
        self._retention_days = retention_days

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this BackupInvocationDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this BackupInvocationDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this BackupInvocationDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this BackupInvocationDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this BackupInvocationDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this BackupInvocationDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this BackupInvocationDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this BackupInvocationDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
