# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BackupPolicy(object):
    """
    BackupPolicy model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BackupPolicy object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_enabled:
            The value to assign to the is_enabled property of this BackupPolicy.
        :type is_enabled: bool

        :param window:
            The value to assign to the window property of this BackupPolicy.
        :type window: str

        :param retention_days:
            The value to assign to the retention_days property of this BackupPolicy.
        :type retention_days: int

        :param freeform_tags:
            The value to assign to the freeform_tags property of this BackupPolicy.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this BackupPolicy.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'is_enabled': 'bool',
            'window': 'str',
            'retention_days': 'int',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'is_enabled': 'isEnabled',
            'window': 'window',
            'retention_days': 'retentionDays',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._is_enabled = None
        self._window = None
        self._retention_days = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def is_enabled(self):
        """
        **[Required]** Gets the is_enabled of this BackupPolicy.
        If automated backups are enabled or disabled.


        :return: The is_enabled of this BackupPolicy.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this BackupPolicy.
        If automated backups are enabled or disabled.


        :param is_enabled: The is_enabled of this BackupPolicy.
        :type: bool
        """
        self._is_enabled = is_enabled

    @property
    def window(self):
        """
        **[Required]** Gets the window of this BackupPolicy.
        The start of a (@FIXME TBD: N-minute-long) window of time in which daily, automated backups occur.

        At some undefined point in the window, the system may incur a brief service disruption as the backup is performed. If the DbSystem does not have HA enabled, then a service interruption is likely. If the DbSystem does have HA enabled, (@FIXME).

        If not defined, a window will be selected at random from the following Region-based time-spans: [@FIXME: table, docs].


        :return: The window of this BackupPolicy.
        :rtype: str
        """
        return self._window

    @window.setter
    def window(self, window):
        """
        Sets the window of this BackupPolicy.
        The start of a (@FIXME TBD: N-minute-long) window of time in which daily, automated backups occur.

        At some undefined point in the window, the system may incur a brief service disruption as the backup is performed. If the DbSystem does not have HA enabled, then a service interruption is likely. If the DbSystem does have HA enabled, (@FIXME).

        If not defined, a window will be selected at random from the following Region-based time-spans: [@FIXME: table, docs].


        :param window: The window of this BackupPolicy.
        :type: str
        """
        self._window = window

    @property
    def retention_days(self):
        """
        Gets the retention_days of this BackupPolicy.
        The number of days automated backups are retained.

        The default is a function of how the configuration was created: CLI/SDK: 5 days, Console: 21 days.


        :return: The retention_days of this BackupPolicy.
        :rtype: int
        """
        return self._retention_days

    @retention_days.setter
    def retention_days(self, retention_days):
        """
        Sets the retention_days of this BackupPolicy.
        The number of days automated backups are retained.

        The default is a function of how the configuration was created: CLI/SDK: 5 days, Console: 21 days.


        :param retention_days: The retention_days of this BackupPolicy.
        :type: int
        """
        self._retention_days = retention_days

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this BackupPolicy.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this BackupPolicy.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this BackupPolicy.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this BackupPolicy.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this BackupPolicy.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this BackupPolicy.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this BackupPolicy.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this BackupPolicy.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
