# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloneOrRestoreFromBackupDetails(object):
    """
    Parameters detailing the backup from which to restore the system.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CloneOrRestoreFromBackupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param backup_id:
            The value to assign to the backup_id property of this CloneOrRestoreFromBackupDetails.
        :type backup_id: str

        :param log_position:
            The value to assign to the log_position property of this CloneOrRestoreFromBackupDetails.
        :type log_position: str

        """
        self.swagger_types = {
            'backup_id': 'str',
            'log_position': 'str'
        }

        self.attribute_map = {
            'backup_id': 'backupId',
            'log_position': 'logPosition'
        }

        self._backup_id = None
        self._log_position = None

    @property
    def backup_id(self):
        """
        **[Required]** Gets the backup_id of this CloneOrRestoreFromBackupDetails.
        The OCID of the backup to use for the restoration procedure. This
        backup must be taken from (TBD or abstractly compatible with?) the
        dbSystem it is being restored to.


        :return: The backup_id of this CloneOrRestoreFromBackupDetails.
        :rtype: str
        """
        return self._backup_id

    @backup_id.setter
    def backup_id(self, backup_id):
        """
        Sets the backup_id of this CloneOrRestoreFromBackupDetails.
        The OCID of the backup to use for the restoration procedure. This
        backup must be taken from (TBD or abstractly compatible with?) the
        dbSystem it is being restored to.


        :param backup_id: The backup_id of this CloneOrRestoreFromBackupDetails.
        :type: str
        """
        self._backup_id = backup_id

    @property
    def log_position(self):
        """
        Gets the log_position of this CloneOrRestoreFromBackupDetails.
        The specific position to recover to. This value maybe one of the following formats:

          - datetime (`RFC 3339`__: describing the point-in-time of recovery.

          - integer: innodb log sequence number.

          - uuid (GTID): specific transaction ID.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The log_position of this CloneOrRestoreFromBackupDetails.
        :rtype: str
        """
        return self._log_position

    @log_position.setter
    def log_position(self, log_position):
        """
        Sets the log_position of this CloneOrRestoreFromBackupDetails.
        The specific position to recover to. This value maybe one of the following formats:

          - datetime (`RFC 3339`__: describing the point-in-time of recovery.

          - integer: innodb log sequence number.

          - uuid (GTID): specific transaction ID.

        __ https://tools.ietf.org/rfc/rfc3339


        :param log_position: The log_position of this CloneOrRestoreFromBackupDetails.
        :type: str
        """
        self._log_position = log_position

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
