# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConfigurationRevisionSummary(object):
    """
    The MySQLaaS Configuration Revision Summary.
    """

    #: A constant which can be used with the status property of a ConfigurationRevisionSummary.
    #: This constant has a value of "PENDING"
    STATUS_PENDING = "PENDING"

    #: A constant which can be used with the status property of a ConfigurationRevisionSummary.
    #: This constant has a value of "APPLYING"
    STATUS_APPLYING = "APPLYING"

    #: A constant which can be used with the status property of a ConfigurationRevisionSummary.
    #: This constant has a value of "APPLIED"
    STATUS_APPLIED = "APPLIED"

    #: A constant which can be used with the status property of a ConfigurationRevisionSummary.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new ConfigurationRevisionSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ConfigurationRevisionSummary.
        :type id: str

        :param time_created:
            The value to assign to the time_created property of this ConfigurationRevisionSummary.
        :type time_created: datetime

        :param status:
            The value to assign to the status property of this ConfigurationRevisionSummary.
            Allowed values for this property are: "PENDING", "APPLYING", "APPLIED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param description:
            The value to assign to the description property of this ConfigurationRevisionSummary.
        :type description: str

        """
        self.swagger_types = {
            'id': 'str',
            'time_created': 'datetime',
            'status': 'str',
            'description': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'time_created': 'timeCreated',
            'status': 'status',
            'description': 'description'
        }

        self._id = None
        self._time_created = None
        self._status = None
        self._description = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ConfigurationRevisionSummary.
        An identifier for this this specific revision of the Configuration
        within the identifier space of this Configuration. Currently an
        auto-increment integer, but not guaranteed to be one; treat as an
        opaque string identifier.


        :return: The id of this ConfigurationRevisionSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ConfigurationRevisionSummary.
        An identifier for this this specific revision of the Configuration
        within the identifier space of this Configuration. Currently an
        auto-increment integer, but not guaranteed to be one; treat as an
        opaque string identifier.


        :param id: The id of this ConfigurationRevisionSummary.
        :type: str
        """
        self._id = id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ConfigurationRevisionSummary.
        Revision creation time, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this ConfigurationRevisionSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ConfigurationRevisionSummary.
        Revision creation time, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this ConfigurationRevisionSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def status(self):
        """
        **[Required]** Gets the status of this ConfigurationRevisionSummary.
        The status of this revision.

        Allowed values for this property are: "PENDING", "APPLYING", "APPLIED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this ConfigurationRevisionSummary.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ConfigurationRevisionSummary.
        The status of this revision.


        :param status: The status of this ConfigurationRevisionSummary.
        :type: str
        """
        allowed_values = ["PENDING", "APPLYING", "APPLIED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def description(self):
        """
        **[Required]** Gets the description of this ConfigurationRevisionSummary.
        A user-provided description for this revision.


        :return: The description of this ConfigurationRevisionSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ConfigurationRevisionSummary.
        A user-provided description for this revision.


        :param description: The description of this ConfigurationRevisionSummary.
        :type: str
        """
        self._description = description

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
