# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CopyConfigurationDetails(object):
    """
    The details required to create a copy of a MySQLaaS Configuration.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CopyConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param description:
            The value to assign to the description property of this CopyConfigurationDetails.
        :type description: str

        :param display_name:
            The value to assign to the display_name property of this CopyConfigurationDetails.
        :type display_name: str

        :param mysql_version:
            The value to assign to the mysql_version property of this CopyConfigurationDetails.
        :type mysql_version: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CopyConfigurationDetails.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CopyConfigurationDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CopyConfigurationDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'description': 'str',
            'display_name': 'str',
            'mysql_version': 'str',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'description': 'description',
            'display_name': 'displayName',
            'mysql_version': 'mysqlVersion',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._description = None
        self._display_name = None
        self._mysql_version = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def description(self):
        """
        Gets the description of this CopyConfigurationDetails.
        User-provided data about the MySQLaaS Instance.


        :return: The description of this CopyConfigurationDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CopyConfigurationDetails.
        User-provided data about the MySQLaaS Instance.


        :param description: The description of this CopyConfigurationDetails.
        :type: str
        """
        self._description = description

    @property
    def display_name(self):
        """
        Gets the display_name of this CopyConfigurationDetails.
        The display name of the MySQLaaS Configuration copy.


        :return: The display_name of this CopyConfigurationDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CopyConfigurationDetails.
        The display name of the MySQLaaS Configuration copy.


        :param display_name: The display_name of this CopyConfigurationDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def mysql_version(self):
        """
        Gets the mysql_version of this CopyConfigurationDetails.
        The version of MySQLaaS that this Configuration and its options are relevant to.


        :return: The mysql_version of this CopyConfigurationDetails.
        :rtype: str
        """
        return self._mysql_version

    @mysql_version.setter
    def mysql_version(self, mysql_version):
        """
        Sets the mysql_version of this CopyConfigurationDetails.
        The version of MySQLaaS that this Configuration and its options are relevant to.


        :param mysql_version: The mysql_version of this CopyConfigurationDetails.
        :type: str
        """
        self._mysql_version = mysql_version

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this CopyConfigurationDetails.
        Optionally, the OCID of the compartment which the MySQLaaS
        Configuration should be copied to. If this is not present, the
        Configuration is copied to the same compartment as the original.


        :return: The compartment_id of this CopyConfigurationDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CopyConfigurationDetails.
        Optionally, the OCID of the compartment which the MySQLaaS
        Configuration should be copied to. If this is not present, the
        Configuration is copied to the same compartment as the original.


        :param compartment_id: The compartment_id of this CopyConfigurationDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CopyConfigurationDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CopyConfigurationDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CopyConfigurationDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CopyConfigurationDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CopyConfigurationDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CopyConfigurationDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CopyConfigurationDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CopyConfigurationDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
