# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateAnalyticsClusterDetails(object):
    """
    Details required to create a MySQLaaS Analytics Cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateAnalyticsClusterDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this CreateAnalyticsClusterDetails.
        :type instance_id: str

        :param description:
            The value to assign to the description property of this CreateAnalyticsClusterDetails.
        :type description: str

        :param shape_name:
            The value to assign to the shape_name property of this CreateAnalyticsClusterDetails.
        :type shape_name: str

        :param cluster_size:
            The value to assign to the cluster_size property of this CreateAnalyticsClusterDetails.
        :type cluster_size: int

        :param host_image_id:
            The value to assign to the host_image_id property of this CreateAnalyticsClusterDetails.
        :type host_image_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateAnalyticsClusterDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateAnalyticsClusterDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'instance_id': 'str',
            'description': 'str',
            'shape_name': 'str',
            'cluster_size': 'int',
            'host_image_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'instance_id': 'instanceId',
            'description': 'description',
            'shape_name': 'shapeName',
            'cluster_size': 'clusterSize',
            'host_image_id': 'hostImageId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._instance_id = None
        self._description = None
        self._shape_name = None
        self._cluster_size = None
        self._host_image_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def instance_id(self):
        """
        Gets the instance_id of this CreateAnalyticsClusterDetails.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The OCID of the MySQLaaS Instance this Analytics Cluster will be associated with.


        :return: The instance_id of this CreateAnalyticsClusterDetails.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this CreateAnalyticsClusterDetails.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The OCID of the MySQLaaS Instance this Analytics Cluster will be associated with.


        :param instance_id: The instance_id of this CreateAnalyticsClusterDetails.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def description(self):
        """
        Gets the description of this CreateAnalyticsClusterDetails.
        User-provided data about the MySQLaaS Instance.


        :return: The description of this CreateAnalyticsClusterDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateAnalyticsClusterDetails.
        User-provided data about the MySQLaaS Instance.


        :param description: The description of this CreateAnalyticsClusterDetails.
        :type: str
        """
        self._description = description

    @property
    def shape_name(self):
        """
        **[Required]** Gets the shape_name of this CreateAnalyticsClusterDetails.
        The shape determines resources to allocate to the MySQLaaS Analyics
        Cluster nodes - CPU cores, memory.


        :return: The shape_name of this CreateAnalyticsClusterDetails.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this CreateAnalyticsClusterDetails.
        The shape determines resources to allocate to the MySQLaaS Analyics
        Cluster nodes - CPU cores, memory.


        :param shape_name: The shape_name of this CreateAnalyticsClusterDetails.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def cluster_size(self):
        """
        **[Required]** Gets the cluster_size of this CreateAnalyticsClusterDetails.
        The number of analytics-processing nodes provisioned for the
        MySQLaaS Analytics Cluster.


        :return: The cluster_size of this CreateAnalyticsClusterDetails.
        :rtype: int
        """
        return self._cluster_size

    @cluster_size.setter
    def cluster_size(self, cluster_size):
        """
        Sets the cluster_size of this CreateAnalyticsClusterDetails.
        The number of analytics-processing nodes provisioned for the
        MySQLaaS Analytics Cluster.


        :param cluster_size: The cluster_size of this CreateAnalyticsClusterDetails.
        :type: int
        """
        self._cluster_size = cluster_size

    @property
    def host_image_id(self):
        """
        Gets the host_image_id of this CreateAnalyticsClusterDetails.
        [PRIVATE API] OCID of the host image used for this Analytics Cluster. If not set, the control plane default will be used.


        :return: The host_image_id of this CreateAnalyticsClusterDetails.
        :rtype: str
        """
        return self._host_image_id

    @host_image_id.setter
    def host_image_id(self, host_image_id):
        """
        Sets the host_image_id of this CreateAnalyticsClusterDetails.
        [PRIVATE API] OCID of the host image used for this Analytics Cluster. If not set, the control plane default will be used.


        :param host_image_id: The host_image_id of this CreateAnalyticsClusterDetails.
        :type: str
        """
        self._host_image_id = host_image_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateAnalyticsClusterDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateAnalyticsClusterDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateAnalyticsClusterDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateAnalyticsClusterDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateAnalyticsClusterDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateAnalyticsClusterDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateAnalyticsClusterDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateAnalyticsClusterDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
