# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateConfigurationDetails(object):
    """
    The details required to create a new MySQLaaS Configuration.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateConfigurationDetails.
        :type compartment_id: str

        :param description:
            The value to assign to the description property of this CreateConfigurationDetails.
        :type description: str

        :param display_name:
            The value to assign to the display_name property of this CreateConfigurationDetails.
        :type display_name: str

        :param shape_name:
            The value to assign to the shape_name property of this CreateConfigurationDetails.
        :type shape_name: str

        :param mysql_version:
            The value to assign to the mysql_version property of this CreateConfigurationDetails.
        :type mysql_version: str

        :param options:
            The value to assign to the options property of this CreateConfigurationDetails.
        :type options: list[Option]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateConfigurationDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateConfigurationDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'description': 'str',
            'display_name': 'str',
            'shape_name': 'str',
            'mysql_version': 'str',
            'options': 'list[Option]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'description': 'description',
            'display_name': 'displayName',
            'shape_name': 'shapeName',
            'mysql_version': 'mysqlVersion',
            'options': 'options',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._compartment_id = None
        self._description = None
        self._display_name = None
        self._shape_name = None
        self._mysql_version = None
        self._options = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateConfigurationDetails.
        The OCID of the compartment.


        :return: The compartment_id of this CreateConfigurationDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateConfigurationDetails.
        The OCID of the compartment.


        :param compartment_id: The compartment_id of this CreateConfigurationDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def description(self):
        """
        Gets the description of this CreateConfigurationDetails.
        User-provided data about the MySQLaaS Instance.


        :return: The description of this CreateConfigurationDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateConfigurationDetails.
        User-provided data about the MySQLaaS Instance.


        :param description: The description of this CreateConfigurationDetails.
        :type: str
        """
        self._description = description

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateConfigurationDetails.
        The display name of the MySQLaaS Configuration.


        :return: The display_name of this CreateConfigurationDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateConfigurationDetails.
        The display name of the MySQLaaS Configuration.


        :param display_name: The display_name of this CreateConfigurationDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def shape_name(self):
        """
        **[Required]** Gets the shape_name of this CreateConfigurationDetails.
        The name of the associated MySQLaaS Instance Shape.


        :return: The shape_name of this CreateConfigurationDetails.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this CreateConfigurationDetails.
        The name of the associated MySQLaaS Instance Shape.


        :param shape_name: The shape_name of this CreateConfigurationDetails.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def mysql_version(self):
        """
        **[Required]** Gets the mysql_version of this CreateConfigurationDetails.
        The version of MySQLaaS that this Configuration and its Options are relevant to.


        :return: The mysql_version of this CreateConfigurationDetails.
        :rtype: str
        """
        return self._mysql_version

    @mysql_version.setter
    def mysql_version(self, mysql_version):
        """
        Sets the mysql_version of this CreateConfigurationDetails.
        The version of MySQLaaS that this Configuration and its Options are relevant to.


        :param mysql_version: The mysql_version of this CreateConfigurationDetails.
        :type: str
        """
        self._mysql_version = mysql_version

    @property
    def options(self):
        """
        Gets the options of this CreateConfigurationDetails.

        :return: The options of this CreateConfigurationDetails.
        :rtype: list[Option]
        """
        return self._options

    @options.setter
    def options(self, options):
        """
        Sets the options of this CreateConfigurationDetails.

        :param options: The options of this CreateConfigurationDetails.
        :type: list[Option]
        """
        self._options = options

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateConfigurationDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateConfigurationDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateConfigurationDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateConfigurationDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateConfigurationDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateConfigurationDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateConfigurationDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateConfigurationDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
