# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDbSystemDetails(object):
    """
    Details required to create a DbSystem.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDbSystemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateDbSystemDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateDbSystemDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateDbSystemDetails.
        :type compartment_id: str

        :param availability_policy:
            The value to assign to the availability_policy property of this CreateDbSystemDetails.
        :type availability_policy: DbSystemAvailabilityPolicy

        :param configuration_id:
            The value to assign to the configuration_id property of this CreateDbSystemDetails.
        :type configuration_id: str

        :param shape_name:
            The value to assign to the shape_name property of this CreateDbSystemDetails.
        :type shape_name: str

        :param mysql_version:
            The value to assign to the mysql_version property of this CreateDbSystemDetails.
        :type mysql_version: str

        :param subnet_id:
            The value to assign to the subnet_id property of this CreateDbSystemDetails.
        :type subnet_id: str

        :param admin_username:
            The value to assign to the admin_username property of this CreateDbSystemDetails.
        :type admin_username: str

        :param admin_password:
            The value to assign to the admin_password property of this CreateDbSystemDetails.
        :type admin_password: str

        :param data_storage_size_in_gbs:
            The value to assign to the data_storage_size_in_gbs property of this CreateDbSystemDetails.
        :type data_storage_size_in_gbs: int

        :param instance:
            The value to assign to the instance property of this CreateDbSystemDetails.
        :type instance: CreateInstanceDetails

        :param backup_policy:
            The value to assign to the backup_policy property of this CreateDbSystemDetails.
        :type backup_policy: CreateUpdateBackupPolicy

        :param clone_from_backup:
            The value to assign to the clone_from_backup property of this CreateDbSystemDetails.
        :type clone_from_backup: CloneOrRestoreFromBackupDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDbSystemDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDbSystemDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'availability_policy': 'DbSystemAvailabilityPolicy',
            'configuration_id': 'str',
            'shape_name': 'str',
            'mysql_version': 'str',
            'subnet_id': 'str',
            'admin_username': 'str',
            'admin_password': 'str',
            'data_storage_size_in_gbs': 'int',
            'instance': 'CreateInstanceDetails',
            'backup_policy': 'CreateUpdateBackupPolicy',
            'clone_from_backup': 'CloneOrRestoreFromBackupDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'availability_policy': 'availabilityPolicy',
            'configuration_id': 'configurationId',
            'shape_name': 'shapeName',
            'mysql_version': 'mysqlVersion',
            'subnet_id': 'subnetId',
            'admin_username': 'adminUsername',
            'admin_password': 'adminPassword',
            'data_storage_size_in_gbs': 'dataStorageSizeInGBs',
            'instance': 'instance',
            'backup_policy': 'backupPolicy',
            'clone_from_backup': 'cloneFromBackup',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._availability_policy = None
        self._configuration_id = None
        self._shape_name = None
        self._mysql_version = None
        self._subnet_id = None
        self._admin_username = None
        self._admin_password = None
        self._data_storage_size_in_gbs = None
        self._instance = None
        self._backup_policy = None
        self._clone_from_backup = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateDbSystemDetails.
        The user-friendly name for the DbSystem. It does not have to be unique.


        :return: The display_name of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateDbSystemDetails.
        The user-friendly name for the DbSystem. It does not have to be unique.


        :param display_name: The display_name of this CreateDbSystemDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateDbSystemDetails.
        User-provided data about the DbSystem.


        :return: The description of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateDbSystemDetails.
        User-provided data about the DbSystem.


        :param description: The description of this CreateDbSystemDetails.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateDbSystemDetails.
        The OCID of the compartment.


        :return: The compartment_id of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateDbSystemDetails.
        The OCID of the compartment.


        :param compartment_id: The compartment_id of this CreateDbSystemDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def availability_policy(self):
        """
        Gets the availability_policy of this CreateDbSystemDetails.

        :return: The availability_policy of this CreateDbSystemDetails.
        :rtype: DbSystemAvailabilityPolicy
        """
        return self._availability_policy

    @availability_policy.setter
    def availability_policy(self, availability_policy):
        """
        Sets the availability_policy of this CreateDbSystemDetails.

        :param availability_policy: The availability_policy of this CreateDbSystemDetails.
        :type: DbSystemAvailabilityPolicy
        """
        self._availability_policy = availability_policy

    @property
    def configuration_id(self):
        """
        Gets the configuration_id of this CreateDbSystemDetails.
        The OCID of the Configuration to be used for Instances in this DbSystem.


        :return: The configuration_id of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._configuration_id

    @configuration_id.setter
    def configuration_id(self, configuration_id):
        """
        Sets the configuration_id of this CreateDbSystemDetails.
        The OCID of the Configuration to be used for Instances in this DbSystem.


        :param configuration_id: The configuration_id of this CreateDbSystemDetails.
        :type: str
        """
        self._configuration_id = configuration_id

    @property
    def shape_name(self):
        """
        **[Required]** Gets the shape_name of this CreateDbSystemDetails.
        The shape of the MySQLaaS instance. The shape determines resources
        allocated to the MySQLaaS instance - CPU cores and memory for VM
        shapes; CPU cores, memory and storage for non-VM (or bare metal)
        shapes. To get a list of shapes, use (FIXME: correct link for
        MySQLaaS shapes) the
        :func:`list_shapes` operation.


        :return: The shape_name of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this CreateDbSystemDetails.
        The shape of the MySQLaaS instance. The shape determines resources
        allocated to the MySQLaaS instance - CPU cores and memory for VM
        shapes; CPU cores, memory and storage for non-VM (or bare metal)
        shapes. To get a list of shapes, use (FIXME: correct link for
        MySQLaaS shapes) the
        :func:`list_shapes` operation.


        :param shape_name: The shape_name of this CreateDbSystemDetails.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def mysql_version(self):
        """
        Gets the mysql_version of this CreateDbSystemDetails.
        The specific MySQL version identifier.


        :return: The mysql_version of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._mysql_version

    @mysql_version.setter
    def mysql_version(self, mysql_version):
        """
        Sets the mysql_version of this CreateDbSystemDetails.
        The specific MySQL version identifier.


        :param mysql_version: The mysql_version of this CreateDbSystemDetails.
        :type: str
        """
        self._mysql_version = mysql_version

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CreateDbSystemDetails.
        The OCID of the subnet the MySQLaaS DbSystem is associated with.


        :return: The subnet_id of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreateDbSystemDetails.
        The OCID of the subnet the MySQLaaS DbSystem is associated with.


        :param subnet_id: The subnet_id of this CreateDbSystemDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def admin_username(self):
        """
        **[Required]** Gets the admin_username of this CreateDbSystemDetails.
        The username for the administrative user for the MySQLaaS Instance.


        :return: The admin_username of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._admin_username

    @admin_username.setter
    def admin_username(self, admin_username):
        """
        Sets the admin_username of this CreateDbSystemDetails.
        The username for the administrative user for the MySQLaaS Instance.


        :param admin_username: The admin_username of this CreateDbSystemDetails.
        :type: str
        """
        self._admin_username = admin_username

    @property
    def admin_password(self):
        """
        **[Required]** Gets the admin_password of this CreateDbSystemDetails.
        The password for the administrative user. The password must be
        between 8 and 32 characters long, and must contain at least 1
        numeric character, 1 lowercase character, 1 uppercase character, and
        1 special (nonalphanumeric) character.


        :return: The admin_password of this CreateDbSystemDetails.
        :rtype: str
        """
        return self._admin_password

    @admin_password.setter
    def admin_password(self, admin_password):
        """
        Sets the admin_password of this CreateDbSystemDetails.
        The password for the administrative user. The password must be
        between 8 and 32 characters long, and must contain at least 1
        numeric character, 1 lowercase character, 1 uppercase character, and
        1 special (nonalphanumeric) character.


        :param admin_password: The admin_password of this CreateDbSystemDetails.
        :type: str
        """
        self._admin_password = admin_password

    @property
    def data_storage_size_in_gbs(self):
        """
        **[Required]** Gets the data_storage_size_in_gbs of this CreateDbSystemDetails.
        Initial size of the data volume in GBs that will be created and attached.
        Keep in mind that this only specifies the size of the database data volume, the log volume
        for the database will be scaled appropriatelly with its shape.
        (TODO: Include more information about db and log BVs and BVG for MySQLaaS.)


        :return: The data_storage_size_in_gbs of this CreateDbSystemDetails.
        :rtype: int
        """
        return self._data_storage_size_in_gbs

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, data_storage_size_in_gbs):
        """
        Sets the data_storage_size_in_gbs of this CreateDbSystemDetails.
        Initial size of the data volume in GBs that will be created and attached.
        Keep in mind that this only specifies the size of the database data volume, the log volume
        for the database will be scaled appropriatelly with its shape.
        (TODO: Include more information about db and log BVs and BVG for MySQLaaS.)


        :param data_storage_size_in_gbs: The data_storage_size_in_gbs of this CreateDbSystemDetails.
        :type: int
        """
        self._data_storage_size_in_gbs = data_storage_size_in_gbs

    @property
    def instance(self):
        """
        **[Required]** Gets the instance of this CreateDbSystemDetails.

        :return: The instance of this CreateDbSystemDetails.
        :rtype: CreateInstanceDetails
        """
        return self._instance

    @instance.setter
    def instance(self, instance):
        """
        Sets the instance of this CreateDbSystemDetails.

        :param instance: The instance of this CreateDbSystemDetails.
        :type: CreateInstanceDetails
        """
        self._instance = instance

    @property
    def backup_policy(self):
        """
        Gets the backup_policy of this CreateDbSystemDetails.

        :return: The backup_policy of this CreateDbSystemDetails.
        :rtype: CreateUpdateBackupPolicy
        """
        return self._backup_policy

    @backup_policy.setter
    def backup_policy(self, backup_policy):
        """
        Sets the backup_policy of this CreateDbSystemDetails.

        :param backup_policy: The backup_policy of this CreateDbSystemDetails.
        :type: CreateUpdateBackupPolicy
        """
        self._backup_policy = backup_policy

    @property
    def clone_from_backup(self):
        """
        Gets the clone_from_backup of this CreateDbSystemDetails.

        :return: The clone_from_backup of this CreateDbSystemDetails.
        :rtype: CloneOrRestoreFromBackupDetails
        """
        return self._clone_from_backup

    @clone_from_backup.setter
    def clone_from_backup(self, clone_from_backup):
        """
        Sets the clone_from_backup of this CreateDbSystemDetails.

        :param clone_from_backup: The clone_from_backup of this CreateDbSystemDetails.
        :type: CloneOrRestoreFromBackupDetails
        """
        self._clone_from_backup = clone_from_backup

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateDbSystemDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateDbSystemDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateDbSystemDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateDbSystemDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateDbSystemDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateDbSystemDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateDbSystemDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateDbSystemDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
