# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateInBoundChannelDetails(object):
    """
    CreateInBoundChannelDetails model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateInBoundChannelDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateInBoundChannelDetails.
        :type compartment_id: str

        :param name:
            The value to assign to the name property of this CreateInBoundChannelDetails.
        :type name: str

        :param description:
            The value to assign to the description property of this CreateInBoundChannelDetails.
        :type description: str

        :param address:
            The value to assign to the address property of this CreateInBoundChannelDetails.
        :type address: str

        :param port:
            The value to assign to the port property of this CreateInBoundChannelDetails.
        :type port: int

        :param username:
            The value to assign to the username property of this CreateInBoundChannelDetails.
        :type username: str

        :param password:
            The value to assign to the password property of this CreateInBoundChannelDetails.
        :type password: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'name': 'str',
            'description': 'str',
            'address': 'str',
            'port': 'int',
            'username': 'str',
            'password': 'str'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'name': 'name',
            'description': 'description',
            'address': 'address',
            'port': 'port',
            'username': 'username',
            'password': 'password'
        }

        self._compartment_id = None
        self._name = None
        self._description = None
        self._address = None
        self._port = None
        self._username = None
        self._password = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateInBoundChannelDetails.
        The Oracle Cloud ID (OCID) of the compartment the DbSystem belongs in.


        :return: The compartment_id of this CreateInBoundChannelDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateInBoundChannelDetails.
        The Oracle Cloud ID (OCID) of the compartment the DbSystem belongs in.


        :param compartment_id: The compartment_id of this CreateInBoundChannelDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateInBoundChannelDetails.
        Name that uniquely identifies the channel.


        :return: The name of this CreateInBoundChannelDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateInBoundChannelDetails.
        Name that uniquely identifies the channel.


        :param name: The name of this CreateInBoundChannelDetails.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this CreateInBoundChannelDetails.
        User-provided data about the in-bound channel.


        :return: The description of this CreateInBoundChannelDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateInBoundChannelDetails.
        User-provided data about the in-bound channel.


        :param description: The description of this CreateInBoundChannelDetails.
        :type: str
        """
        self._description = description

    @property
    def address(self):
        """
        **[Required]** Gets the address of this CreateInBoundChannelDetails.
        Address a MySQLaaS instance or DbSystem connects to receive data changes.


        :return: The address of this CreateInBoundChannelDetails.
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address):
        """
        Sets the address of this CreateInBoundChannelDetails.
        Address a MySQLaaS instance or DbSystem connects to receive data changes.


        :param address: The address of this CreateInBoundChannelDetails.
        :type: str
        """
        self._address = address

    @property
    def port(self):
        """
        Gets the port of this CreateInBoundChannelDetails.
        Port a MySQLaaS instance or DbSystem connects to receive data changes. Default 3306.


        :return: The port of this CreateInBoundChannelDetails.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this CreateInBoundChannelDetails.
        Port a MySQLaaS instance or DbSystem connects to receive data changes. Default 3306.


        :param port: The port of this CreateInBoundChannelDetails.
        :type: int
        """
        self._port = port

    @property
    def username(self):
        """
        **[Required]** Gets the username of this CreateInBoundChannelDetails.
        The username the MySQLaaS instance or DbSystem uses to connect to an entity to
        receive data changes.


        :return: The username of this CreateInBoundChannelDetails.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this CreateInBoundChannelDetails.
        The username the MySQLaaS instance or DbSystem uses to connect to an entity to
        receive data changes.


        :param username: The username of this CreateInBoundChannelDetails.
        :type: str
        """
        self._username = username

    @property
    def password(self):
        """
        **[Required]** Gets the password of this CreateInBoundChannelDetails.
        The user's password MySQLaaS instance or DbSystem uses to connect to an entity
        to receive data changes.


        :return: The password of this CreateInBoundChannelDetails.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this CreateInBoundChannelDetails.
        The user's password MySQLaaS instance or DbSystem uses to connect to an entity
        to receive data changes.


        :param password: The password of this CreateInBoundChannelDetails.
        :type: str
        """
        self._password = password

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
