# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateInstanceDetails(object):
    """
    Details required to create a new instance in an existing DbSystem.
    """

    #: A constant which can be used with the role property of a CreateInstanceDetails.
    #: This constant has a value of "STANDALONE"
    ROLE_STANDALONE = "STANDALONE"

    #: A constant which can be used with the role property of a CreateInstanceDetails.
    #: This constant has a value of "PRIMARY"
    ROLE_PRIMARY = "PRIMARY"

    #: A constant which can be used with the role property of a CreateInstanceDetails.
    #: This constant has a value of "SECONDARY"
    ROLE_SECONDARY = "SECONDARY"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateInstanceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param db_system_id:
            The value to assign to the db_system_id property of this CreateInstanceDetails.
        :type db_system_id: str

        :param role:
            The value to assign to the role property of this CreateInstanceDetails.
            Allowed values for this property are: "STANDALONE", "PRIMARY", "SECONDARY"
        :type role: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateInstanceDetails.
        :type compartment_id: str

        :param description:
            The value to assign to the description property of this CreateInstanceDetails.
        :type description: str

        :param display_name:
            The value to assign to the display_name property of this CreateInstanceDetails.
        :type display_name: str

        :param admin_username:
            The value to assign to the admin_username property of this CreateInstanceDetails.
        :type admin_username: str

        :param admin_password:
            The value to assign to the admin_password property of this CreateInstanceDetails.
        :type admin_password: str

        :param availability_domain:
            The value to assign to the availability_domain property of this CreateInstanceDetails.
        :type availability_domain: str

        :param fault_domain:
            The value to assign to the fault_domain property of this CreateInstanceDetails.
        :type fault_domain: str

        :param subnet_id:
            The value to assign to the subnet_id property of this CreateInstanceDetails.
        :type subnet_id: str

        :param shape_name:
            The value to assign to the shape_name property of this CreateInstanceDetails.
        :type shape_name: str

        :param configuration_id:
            The value to assign to the configuration_id property of this CreateInstanceDetails.
        :type configuration_id: str

        :param data_storage_size_in_gbs:
            The value to assign to the data_storage_size_in_gbs property of this CreateInstanceDetails.
        :type data_storage_size_in_gbs: int

        :param port:
            The value to assign to the port property of this CreateInstanceDetails.
        :type port: int

        :param mysqlx_port:
            The value to assign to the mysqlx_port property of this CreateInstanceDetails.
        :type mysqlx_port: int

        :param hostname:
            The value to assign to the hostname property of this CreateInstanceDetails.
        :type hostname: str

        :param analytics_cluster:
            The value to assign to the analytics_cluster property of this CreateInstanceDetails.
        :type analytics_cluster: CreateAnalyticsClusterDetails

        :param host_image_id:
            The value to assign to the host_image_id property of this CreateInstanceDetails.
        :type host_image_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateInstanceDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateInstanceDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param backup_id:
            The value to assign to the backup_id property of this CreateInstanceDetails.
        :type backup_id: str

        """
        self.swagger_types = {
            'db_system_id': 'str',
            'role': 'str',
            'compartment_id': 'str',
            'description': 'str',
            'display_name': 'str',
            'admin_username': 'str',
            'admin_password': 'str',
            'availability_domain': 'str',
            'fault_domain': 'str',
            'subnet_id': 'str',
            'shape_name': 'str',
            'configuration_id': 'str',
            'data_storage_size_in_gbs': 'int',
            'port': 'int',
            'mysqlx_port': 'int',
            'hostname': 'str',
            'analytics_cluster': 'CreateAnalyticsClusterDetails',
            'host_image_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'backup_id': 'str'
        }

        self.attribute_map = {
            'db_system_id': 'dbSystemId',
            'role': 'role',
            'compartment_id': 'compartmentId',
            'description': 'description',
            'display_name': 'displayName',
            'admin_username': 'adminUsername',
            'admin_password': 'adminPassword',
            'availability_domain': 'availabilityDomain',
            'fault_domain': 'faultDomain',
            'subnet_id': 'subnetId',
            'shape_name': 'shapeName',
            'configuration_id': 'configurationId',
            'data_storage_size_in_gbs': 'dataStorageSizeInGBs',
            'port': 'port',
            'mysqlx_port': 'mysqlxPort',
            'hostname': 'hostname',
            'analytics_cluster': 'analyticsCluster',
            'host_image_id': 'hostImageId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'backup_id': 'backupId'
        }

        self._db_system_id = None
        self._role = None
        self._compartment_id = None
        self._description = None
        self._display_name = None
        self._admin_username = None
        self._admin_password = None
        self._availability_domain = None
        self._fault_domain = None
        self._subnet_id = None
        self._shape_name = None
        self._configuration_id = None
        self._data_storage_size_in_gbs = None
        self._port = None
        self._mysqlx_port = None
        self._hostname = None
        self._analytics_cluster = None
        self._host_image_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._backup_id = None

    @property
    def db_system_id(self):
        """
        Gets the db_system_id of this CreateInstanceDetails.
        The Oracle Cloud ID (OCID) of the DbSystem the MySQLaaS instance belongs in.


        :return: The db_system_id of this CreateInstanceDetails.
        :rtype: str
        """
        return self._db_system_id

    @db_system_id.setter
    def db_system_id(self, db_system_id):
        """
        Sets the db_system_id of this CreateInstanceDetails.
        The Oracle Cloud ID (OCID) of the DbSystem the MySQLaaS instance belongs in.


        :param db_system_id: The db_system_id of this CreateInstanceDetails.
        :type: str
        """
        self._db_system_id = db_system_id

    @property
    def role(self):
        """
        Gets the role of this CreateInstanceDetails.
        Role played by this Instance in the DbSystem.

        Allowed values for this property are: "STANDALONE", "PRIMARY", "SECONDARY"


        :return: The role of this CreateInstanceDetails.
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """
        Sets the role of this CreateInstanceDetails.
        Role played by this Instance in the DbSystem.


        :param role: The role of this CreateInstanceDetails.
        :type: str
        """
        allowed_values = ["STANDALONE", "PRIMARY", "SECONDARY"]
        if not value_allowed_none_or_none_sentinel(role, allowed_values):
            raise ValueError(
                "Invalid value for `role`, must be None or one of {0}"
                .format(allowed_values)
            )
        self._role = role

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this CreateInstanceDetails.
        DEPRECATED -- The Oracle Cloud ID (OCID) of the compartment the MySQLaaS instance belongs in.


        :return: The compartment_id of this CreateInstanceDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateInstanceDetails.
        DEPRECATED -- The Oracle Cloud ID (OCID) of the compartment the MySQLaaS instance belongs in.


        :param compartment_id: The compartment_id of this CreateInstanceDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def description(self):
        """
        Gets the description of this CreateInstanceDetails.
        User-provided data about the MySQLaaS Instance.


        :return: The description of this CreateInstanceDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateInstanceDetails.
        User-provided data about the MySQLaaS Instance.


        :param description: The description of this CreateInstanceDetails.
        :type: str
        """
        self._description = description

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateInstanceDetails.
        The user-friendly name for the MySQLaaS Instance. It does not have to be unique.


        :return: The display_name of this CreateInstanceDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateInstanceDetails.
        The user-friendly name for the MySQLaaS Instance. It does not have to be unique.


        :param display_name: The display_name of this CreateInstanceDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def admin_username(self):
        """
        Gets the admin_username of this CreateInstanceDetails.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The username for the administrative user for the MySQLaaS Instance.


        :return: The admin_username of this CreateInstanceDetails.
        :rtype: str
        """
        return self._admin_username

    @admin_username.setter
    def admin_username(self, admin_username):
        """
        Sets the admin_username of this CreateInstanceDetails.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The username for the administrative user for the MySQLaaS Instance.


        :param admin_username: The admin_username of this CreateInstanceDetails.
        :type: str
        """
        self._admin_username = admin_username

    @property
    def admin_password(self):
        """
        Gets the admin_password of this CreateInstanceDetails.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The password for the administrative user. The password must be
        between 8 and 32 characters long, and must contain at least 1
        numeric character, 1 lowercase character, 1 uppercase character, and
        1 special (nonalphanumeric) character.


        :return: The admin_password of this CreateInstanceDetails.
        :rtype: str
        """
        return self._admin_password

    @admin_password.setter
    def admin_password(self, admin_password):
        """
        Sets the admin_password of this CreateInstanceDetails.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The password for the administrative user. The password must be
        between 8 and 32 characters long, and must contain at least 1
        numeric character, 1 lowercase character, 1 uppercase character, and
        1 special (nonalphanumeric) character.


        :param admin_password: The admin_password of this CreateInstanceDetails.
        :type: str
        """
        self._admin_password = admin_password

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this CreateInstanceDetails.
        The Availability Domain where the MySQLaaS instance is located.


        :return: The availability_domain of this CreateInstanceDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this CreateInstanceDetails.
        The Availability Domain where the MySQLaaS instance is located.


        :param availability_domain: The availability_domain of this CreateInstanceDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def fault_domain(self):
        """
        Gets the fault_domain of this CreateInstanceDetails.
        The name of the Fault Domain the MySQLaaS instance is located in.


        :return: The fault_domain of this CreateInstanceDetails.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this CreateInstanceDetails.
        The name of the Fault Domain the MySQLaaS instance is located in.


        :param fault_domain: The fault_domain of this CreateInstanceDetails.
        :type: str
        """
        self._fault_domain = fault_domain

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this CreateInstanceDetails.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The OCID of the subnet the MySQLaaS instance is associated with.


        :return: The subnet_id of this CreateInstanceDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreateInstanceDetails.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The OCID of the subnet the MySQLaaS instance is associated with.


        :param subnet_id: The subnet_id of this CreateInstanceDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def shape_name(self):
        """
        Gets the shape_name of this CreateInstanceDetails.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The shape of the MySQLaaS instance. The shape determines resources
        allocated to the MySQLaaS instance - CPU cores and memory for VM
        shapes; CPU cores, memory and storage for non-VM (or bare metal)
        shapes. To get a list of shapes, use (FIXME: correct link for
        MySQLaaS shapes) the
        :func:`list_shapes` operation.


        :return: The shape_name of this CreateInstanceDetails.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this CreateInstanceDetails.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The shape of the MySQLaaS instance. The shape determines resources
        allocated to the MySQLaaS instance - CPU cores and memory for VM
        shapes; CPU cores, memory and storage for non-VM (or bare metal)
        shapes. To get a list of shapes, use (FIXME: correct link for
        MySQLaaS shapes) the
        :func:`list_shapes` operation.


        :param shape_name: The shape_name of this CreateInstanceDetails.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def configuration_id(self):
        """
        Gets the configuration_id of this CreateInstanceDetails.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        OCID of the MySQL Configuration associated with this instance.


        :return: The configuration_id of this CreateInstanceDetails.
        :rtype: str
        """
        return self._configuration_id

    @configuration_id.setter
    def configuration_id(self, configuration_id):
        """
        Sets the configuration_id of this CreateInstanceDetails.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        OCID of the MySQL Configuration associated with this instance.


        :param configuration_id: The configuration_id of this CreateInstanceDetails.
        :type: str
        """
        self._configuration_id = configuration_id

    @property
    def data_storage_size_in_gbs(self):
        """
        Gets the data_storage_size_in_gbs of this CreateInstanceDetails.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        Initial size (GBs) of the data volume created and attached.
        This only specifies the size of the database data volume, the log volume
        for the database is scaled according to the specified shape.

        (TODO: Include more information about db and log BVs and BVG for MySQLaaS.)


        :return: The data_storage_size_in_gbs of this CreateInstanceDetails.
        :rtype: int
        """
        return self._data_storage_size_in_gbs

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, data_storage_size_in_gbs):
        """
        Sets the data_storage_size_in_gbs of this CreateInstanceDetails.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        Initial size (GBs) of the data volume created and attached.
        This only specifies the size of the database data volume, the log volume
        for the database is scaled according to the specified shape.

        (TODO: Include more information about db and log BVs and BVG for MySQLaaS.)


        :param data_storage_size_in_gbs: The data_storage_size_in_gbs of this CreateInstanceDetails.
        :type: int
        """
        self._data_storage_size_in_gbs = data_storage_size_in_gbs

    @property
    def port(self):
        """
        Gets the port of this CreateInstanceDetails.
        The port MySQLaaS instance is configured to listen on.


        :return: The port of this CreateInstanceDetails.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this CreateInstanceDetails.
        The port MySQLaaS instance is configured to listen on.


        :param port: The port of this CreateInstanceDetails.
        :type: int
        """
        self._port = port

    @property
    def mysqlx_port(self):
        """
        Gets the mysqlx_port of this CreateInstanceDetails.
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.


        :return: The mysqlx_port of this CreateInstanceDetails.
        :rtype: int
        """
        return self._mysqlx_port

    @mysqlx_port.setter
    def mysqlx_port(self, mysqlx_port):
        """
        Sets the mysqlx_port of this CreateInstanceDetails.
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.


        :param mysqlx_port: The mysqlx_port of this CreateInstanceDetails.
        :type: int
        """
        self._mysqlx_port = mysqlx_port

    @property
    def hostname(self):
        """
        Gets the hostname of this CreateInstanceDetails.
        The host name for the MySQLaaS Instance. The host name must begin with an alphabetic character and
        can contain a maximum of 30 alphanumeric characters, including hyphens (-).

        The maximum length of the combined hostname and domain is 63 characters.

        **Note:** The hostname must be unique within the subnet.
         It is not possible to provision a MySQLaaS instance if the hostname is not unique.


        :return: The hostname of this CreateInstanceDetails.
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """
        Sets the hostname of this CreateInstanceDetails.
        The host name for the MySQLaaS Instance. The host name must begin with an alphabetic character and
        can contain a maximum of 30 alphanumeric characters, including hyphens (-).

        The maximum length of the combined hostname and domain is 63 characters.

        **Note:** The hostname must be unique within the subnet.
         It is not possible to provision a MySQLaaS instance if the hostname is not unique.


        :param hostname: The hostname of this CreateInstanceDetails.
        :type: str
        """
        self._hostname = hostname

    @property
    def analytics_cluster(self):
        """
        Gets the analytics_cluster of this CreateInstanceDetails.

        :return: The analytics_cluster of this CreateInstanceDetails.
        :rtype: CreateAnalyticsClusterDetails
        """
        return self._analytics_cluster

    @analytics_cluster.setter
    def analytics_cluster(self, analytics_cluster):
        """
        Sets the analytics_cluster of this CreateInstanceDetails.

        :param analytics_cluster: The analytics_cluster of this CreateInstanceDetails.
        :type: CreateAnalyticsClusterDetails
        """
        self._analytics_cluster = analytics_cluster

    @property
    def host_image_id(self):
        """
        Gets the host_image_id of this CreateInstanceDetails.
        [PRIVATE API] OCID of the host image to use for this Instance. If not set, the control plane default will be used.


        :return: The host_image_id of this CreateInstanceDetails.
        :rtype: str
        """
        return self._host_image_id

    @host_image_id.setter
    def host_image_id(self, host_image_id):
        """
        Sets the host_image_id of this CreateInstanceDetails.
        [PRIVATE API] OCID of the host image to use for this Instance. If not set, the control plane default will be used.


        :param host_image_id: The host_image_id of this CreateInstanceDetails.
        :type: str
        """
        self._host_image_id = host_image_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateInstanceDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateInstanceDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateInstanceDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateInstanceDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateInstanceDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateInstanceDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateInstanceDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateInstanceDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def backup_id(self):
        """
        Gets the backup_id of this CreateInstanceDetails.
        The Backup Id from which the instance should be restored.


        :return: The backup_id of this CreateInstanceDetails.
        :rtype: str
        """
        return self._backup_id

    @backup_id.setter
    def backup_id(self, backup_id):
        """
        Sets the backup_id of this CreateInstanceDetails.
        The Backup Id from which the instance should be restored.


        :param backup_id: The backup_id of this CreateInstanceDetails.
        :type: str
        """
        self._backup_id = backup_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
