# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateUpdateBackupPolicy(object):
    """
    Backup Configuration object as optionally used for instance
    creation/update. No fields are required, in which case default values
    are determined and used as per the documentation.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateUpdateBackupPolicy object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_enabled:
            The value to assign to the is_enabled property of this CreateUpdateBackupPolicy.
        :type is_enabled: bool

        :param window:
            The value to assign to the window property of this CreateUpdateBackupPolicy.
        :type window: str

        :param retention_days:
            The value to assign to the retention_days property of this CreateUpdateBackupPolicy.
        :type retention_days: int

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateUpdateBackupPolicy.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateUpdateBackupPolicy.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'is_enabled': 'bool',
            'window': 'str',
            'retention_days': 'int',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'is_enabled': 'isEnabled',
            'window': 'window',
            'retention_days': 'retentionDays',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._is_enabled = None
        self._window = None
        self._retention_days = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def is_enabled(self):
        """
        Gets the is_enabled of this CreateUpdateBackupPolicy.
        # @fixme copy


        :return: The is_enabled of this CreateUpdateBackupPolicy.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this CreateUpdateBackupPolicy.
        # @fixme copy


        :param is_enabled: The is_enabled of this CreateUpdateBackupPolicy.
        :type: bool
        """
        self._is_enabled = is_enabled

    @property
    def window(self):
        """
        Gets the window of this CreateUpdateBackupPolicy.
        # @fixme copy


        :return: The window of this CreateUpdateBackupPolicy.
        :rtype: str
        """
        return self._window

    @window.setter
    def window(self, window):
        """
        Sets the window of this CreateUpdateBackupPolicy.
        # @fixme copy


        :param window: The window of this CreateUpdateBackupPolicy.
        :type: str
        """
        self._window = window

    @property
    def retention_days(self):
        """
        Gets the retention_days of this CreateUpdateBackupPolicy.
        # @fixme copy


        :return: The retention_days of this CreateUpdateBackupPolicy.
        :rtype: int
        """
        return self._retention_days

    @retention_days.setter
    def retention_days(self, retention_days):
        """
        Sets the retention_days of this CreateUpdateBackupPolicy.
        # @fixme copy


        :param retention_days: The retention_days of this CreateUpdateBackupPolicy.
        :type: int
        """
        self._retention_days = retention_days

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateUpdateBackupPolicy.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateUpdateBackupPolicy.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateUpdateBackupPolicy.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateUpdateBackupPolicy.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateUpdateBackupPolicy.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateUpdateBackupPolicy.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateUpdateBackupPolicy.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.

        Tags defined here will be copied verbatim as tags on the Backup resource created by this BackupPolicy.

        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateUpdateBackupPolicy.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
