# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbSystem(object):
    """
    A DbSystem is a logical set of data and collection of Instances to provide various levels of MySQL as a Service.
    """

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new DbSystem object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DbSystem.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this DbSystem.
        :type display_name: str

        :param description:
            The value to assign to the description property of this DbSystem.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DbSystem.
        :type compartment_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this DbSystem.
        :type subnet_id: str

        :param availability_policy:
            The value to assign to the availability_policy property of this DbSystem.
        :type availability_policy: DbSystemAvailabilityPolicy

        :param shape_name:
            The value to assign to the shape_name property of this DbSystem.
        :type shape_name: str

        :param mysql_version:
            The value to assign to the mysql_version property of this DbSystem.
        :type mysql_version: str

        :param instances:
            The value to assign to the instances property of this DbSystem.
        :type instances: list[DbSystemInstance]

        :param backup_policy:
            The value to assign to the backup_policy property of this DbSystem.
        :type backup_policy: BackupPolicy

        :param configuration_id:
            The value to assign to the configuration_id property of this DbSystem.
        :type configuration_id: str

        :param data_storage_size_in_gbs:
            The value to assign to the data_storage_size_in_gbs property of this DbSystem.
        :type data_storage_size_in_gbs: int

        :param in_bound_channels:
            The value to assign to the in_bound_channels property of this DbSystem.
        :type in_bound_channels: list[InBoundChannel]

        :param endpoints:
            The value to assign to the endpoints property of this DbSystem.
        :type endpoints: list[DbSystemEndpoint]

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DbSystem.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this DbSystem.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this DbSystem.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DbSystem.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DbSystem.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DbSystem.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'subnet_id': 'str',
            'availability_policy': 'DbSystemAvailabilityPolicy',
            'shape_name': 'str',
            'mysql_version': 'str',
            'instances': 'list[DbSystemInstance]',
            'backup_policy': 'BackupPolicy',
            'configuration_id': 'str',
            'data_storage_size_in_gbs': 'int',
            'in_bound_channels': 'list[InBoundChannel]',
            'endpoints': 'list[DbSystemEndpoint]',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'subnet_id': 'subnetId',
            'availability_policy': 'availabilityPolicy',
            'shape_name': 'shapeName',
            'mysql_version': 'mysqlVersion',
            'instances': 'instances',
            'backup_policy': 'backupPolicy',
            'configuration_id': 'configurationId',
            'data_storage_size_in_gbs': 'dataStorageSizeInGBs',
            'in_bound_channels': 'inBoundChannels',
            'endpoints': 'endpoints',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._subnet_id = None
        self._availability_policy = None
        self._shape_name = None
        self._mysql_version = None
        self._instances = None
        self._backup_policy = None
        self._configuration_id = None
        self._data_storage_size_in_gbs = None
        self._in_bound_channels = None
        self._endpoints = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DbSystem.
        The OCID of the DbSystem.


        :return: The id of this DbSystem.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DbSystem.
        The OCID of the DbSystem.


        :param id: The id of this DbSystem.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DbSystem.
        The user-friendly name for the DbSystem. It does not have to be unique.


        :return: The display_name of this DbSystem.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DbSystem.
        The user-friendly name for the DbSystem. It does not have to be unique.


        :param display_name: The display_name of this DbSystem.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this DbSystem.
        User-provided data about the DbSystem.


        :return: The description of this DbSystem.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DbSystem.
        User-provided data about the DbSystem.


        :param description: The description of this DbSystem.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DbSystem.
        The Oracle Cloud ID (OCID) of the compartment the DbSystem belongs in.


        :return: The compartment_id of this DbSystem.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DbSystem.
        The Oracle Cloud ID (OCID) of the compartment the DbSystem belongs in.


        :param compartment_id: The compartment_id of this DbSystem.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this DbSystem.
        The OCID of the subnet the MySQLaaS DbSystem is associated with.


        :return: The subnet_id of this DbSystem.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this DbSystem.
        The OCID of the subnet the MySQLaaS DbSystem is associated with.


        :param subnet_id: The subnet_id of this DbSystem.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def availability_policy(self):
        """
        **[Required]** Gets the availability_policy of this DbSystem.

        :return: The availability_policy of this DbSystem.
        :rtype: DbSystemAvailabilityPolicy
        """
        return self._availability_policy

    @availability_policy.setter
    def availability_policy(self, availability_policy):
        """
        Sets the availability_policy of this DbSystem.

        :param availability_policy: The availability_policy of this DbSystem.
        :type: DbSystemAvailabilityPolicy
        """
        self._availability_policy = availability_policy

    @property
    def shape_name(self):
        """
        Gets the shape_name of this DbSystem.
        The shape of the primary instances of the DbSystem. The shape
        determines resources allocated to a MySQLaaS instance - CPU cores
        and memory for VM shapes; CPU cores, memory and storage for non-VM
        (or bare metal) shapes. To get a list of shapes, use (FIXME: correct
        link for MySQLaaS shapes) the
        :func:`list_shapes` operation.


        :return: The shape_name of this DbSystem.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this DbSystem.
        The shape of the primary instances of the DbSystem. The shape
        determines resources allocated to a MySQLaaS instance - CPU cores
        and memory for VM shapes; CPU cores, memory and storage for non-VM
        (or bare metal) shapes. To get a list of shapes, use (FIXME: correct
        link for MySQLaaS shapes) the
        :func:`list_shapes` operation.


        :param shape_name: The shape_name of this DbSystem.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def mysql_version(self):
        """
        **[Required]** Gets the mysql_version of this DbSystem.
        Name of the MySQL Version in use for the DB System.


        :return: The mysql_version of this DbSystem.
        :rtype: str
        """
        return self._mysql_version

    @mysql_version.setter
    def mysql_version(self, mysql_version):
        """
        Sets the mysql_version of this DbSystem.
        Name of the MySQL Version in use for the DB System.


        :param mysql_version: The mysql_version of this DbSystem.
        :type: str
        """
        self._mysql_version = mysql_version

    @property
    def instances(self):
        """
        Gets the instances of this DbSystem.

        :return: The instances of this DbSystem.
        :rtype: list[DbSystemInstance]
        """
        return self._instances

    @instances.setter
    def instances(self, instances):
        """
        Sets the instances of this DbSystem.

        :param instances: The instances of this DbSystem.
        :type: list[DbSystemInstance]
        """
        self._instances = instances

    @property
    def backup_policy(self):
        """
        Gets the backup_policy of this DbSystem.

        :return: The backup_policy of this DbSystem.
        :rtype: BackupPolicy
        """
        return self._backup_policy

    @backup_policy.setter
    def backup_policy(self, backup_policy):
        """
        Sets the backup_policy of this DbSystem.

        :param backup_policy: The backup_policy of this DbSystem.
        :type: BackupPolicy
        """
        self._backup_policy = backup_policy

    @property
    def configuration_id(self):
        """
        Gets the configuration_id of this DbSystem.
        The OCID of the Configuration to be used for Instances in this DbSystem.


        :return: The configuration_id of this DbSystem.
        :rtype: str
        """
        return self._configuration_id

    @configuration_id.setter
    def configuration_id(self, configuration_id):
        """
        Sets the configuration_id of this DbSystem.
        The OCID of the Configuration to be used for Instances in this DbSystem.


        :param configuration_id: The configuration_id of this DbSystem.
        :type: str
        """
        self._configuration_id = configuration_id

    @property
    def data_storage_size_in_gbs(self):
        """
        **[Required]** Gets the data_storage_size_in_gbs of this DbSystem.
        Initial size of the data volume in GiBs that will be created and attached.
        Keep in mind that this only specifies the size of the database data volume, the log volume
        for the database will be scaled appropriatelly with its shape.
        (TODO: Include more information about db and log BVs and BVG for MySQLaaS.)


        :return: The data_storage_size_in_gbs of this DbSystem.
        :rtype: int
        """
        return self._data_storage_size_in_gbs

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, data_storage_size_in_gbs):
        """
        Sets the data_storage_size_in_gbs of this DbSystem.
        Initial size of the data volume in GiBs that will be created and attached.
        Keep in mind that this only specifies the size of the database data volume, the log volume
        for the database will be scaled appropriatelly with its shape.
        (TODO: Include more information about db and log BVs and BVG for MySQLaaS.)


        :param data_storage_size_in_gbs: The data_storage_size_in_gbs of this DbSystem.
        :type: int
        """
        self._data_storage_size_in_gbs = data_storage_size_in_gbs

    @property
    def in_bound_channels(self):
        """
        Gets the in_bound_channels of this DbSystem.

        :return: The in_bound_channels of this DbSystem.
        :rtype: list[InBoundChannel]
        """
        return self._in_bound_channels

    @in_bound_channels.setter
    def in_bound_channels(self, in_bound_channels):
        """
        Sets the in_bound_channels of this DbSystem.

        :param in_bound_channels: The in_bound_channels of this DbSystem.
        :type: list[InBoundChannel]
        """
        self._in_bound_channels = in_bound_channels

    @property
    def endpoints(self):
        """
        Gets the endpoints of this DbSystem.

        :return: The endpoints of this DbSystem.
        :rtype: list[DbSystemEndpoint]
        """
        return self._endpoints

    @endpoints.setter
    def endpoints(self, endpoints):
        """
        Sets the endpoints of this DbSystem.

        :param endpoints: The endpoints of this DbSystem.
        :type: list[DbSystemEndpoint]
        """
        self._endpoints = endpoints

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this DbSystem.
        The current state of the DbSystem.

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DbSystem.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DbSystem.
        The current state of the DbSystem.


        :param lifecycle_state: The lifecycle_state of this DbSystem.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this DbSystem.
        Additional information about the current lifecycleState.


        :return: The lifecycle_details of this DbSystem.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this DbSystem.
        Additional information about the current lifecycleState.


        :param lifecycle_details: The lifecycle_details of this DbSystem.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DbSystem.
        The date and time the DbSystem was created.


        :return: The time_created of this DbSystem.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DbSystem.
        The date and time the DbSystem was created.


        :param time_created: The time_created of this DbSystem.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this DbSystem.
        The time the DbSystem was last updated.


        :return: The time_updated of this DbSystem.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DbSystem.
        The time the DbSystem was last updated.


        :param time_updated: The time_updated of this DbSystem.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DbSystem.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this DbSystem.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DbSystem.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this DbSystem.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DbSystem.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this DbSystem.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DbSystem.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this DbSystem.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
