# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbSystemAvailabilityPolicy(object):
    """
    Details of high-availability policy.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DbSystemAvailabilityPolicy object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_highly_available:
            The value to assign to the is_highly_available property of this DbSystemAvailabilityPolicy.
        :type is_highly_available: bool

        :param preferred_placement_order:
            The value to assign to the preferred_placement_order property of this DbSystemAvailabilityPolicy.
        :type preferred_placement_order: list[AdFd]

        """
        self.swagger_types = {
            'is_highly_available': 'bool',
            'preferred_placement_order': 'list[AdFd]'
        }

        self.attribute_map = {
            'is_highly_available': 'isHighlyAvailable',
            'preferred_placement_order': 'preferredPlacementOrder'
        }

        self._is_highly_available = None
        self._preferred_placement_order = None

    @property
    def is_highly_available(self):
        """
        **[Required]** Gets the is_highly_available of this DbSystemAvailabilityPolicy.
        If the policy is to enable high availability of the instance, by
        maintaining secondary/failover capacity as necessary.


        :return: The is_highly_available of this DbSystemAvailabilityPolicy.
        :rtype: bool
        """
        return self._is_highly_available

    @is_highly_available.setter
    def is_highly_available(self, is_highly_available):
        """
        Sets the is_highly_available of this DbSystemAvailabilityPolicy.
        If the policy is to enable high availability of the instance, by
        maintaining secondary/failover capacity as necessary.


        :param is_highly_available: The is_highly_available of this DbSystemAvailabilityPolicy.
        :type: bool
        """
        self._is_highly_available = is_highly_available

    @property
    def preferred_placement_order(self):
        """
        Gets the preferred_placement_order of this DbSystemAvailabilityPolicy.
        Optional. If set, defines the *preferred* availability-domain and
        fault-domains of candidate instances, as an ordered list.


        :return: The preferred_placement_order of this DbSystemAvailabilityPolicy.
        :rtype: list[AdFd]
        """
        return self._preferred_placement_order

    @preferred_placement_order.setter
    def preferred_placement_order(self, preferred_placement_order):
        """
        Sets the preferred_placement_order of this DbSystemAvailabilityPolicy.
        Optional. If set, defines the *preferred* availability-domain and
        fault-domains of candidate instances, as an ordered list.


        :param preferred_placement_order: The preferred_placement_order of this DbSystemAvailabilityPolicy.
        :type: list[AdFd]
        """
        self._preferred_placement_order = preferred_placement_order

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
