# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbSystemEndpoint(object):
    """
    DbSystemEndpoint model.
    """

    #: A constant which can be used with the endpoint_type property of a DbSystemEndpoint.
    #: This constant has a value of "READ_WRITE"
    ENDPOINT_TYPE_READ_WRITE = "READ_WRITE"

    #: A constant which can be used with the endpoint_type property of a DbSystemEndpoint.
    #: This constant has a value of "READ_ONLY"
    ENDPOINT_TYPE_READ_ONLY = "READ_ONLY"

    def __init__(self, **kwargs):
        """
        Initializes a new DbSystemEndpoint object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param endpoint_type:
            The value to assign to the endpoint_type property of this DbSystemEndpoint.
            Allowed values for this property are: "READ_WRITE", "READ_ONLY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type endpoint_type: str

        :param ip_address:
            The value to assign to the ip_address property of this DbSystemEndpoint.
        :type ip_address: str

        :param port:
            The value to assign to the port property of this DbSystemEndpoint.
        :type port: int

        :param mysqlx_port:
            The value to assign to the mysqlx_port property of this DbSystemEndpoint.
        :type mysqlx_port: int

        """
        self.swagger_types = {
            'endpoint_type': 'str',
            'ip_address': 'str',
            'port': 'int',
            'mysqlx_port': 'int'
        }

        self.attribute_map = {
            'endpoint_type': 'endpointType',
            'ip_address': 'ipAddress',
            'port': 'port',
            'mysqlx_port': 'mysqlxPort'
        }

        self._endpoint_type = None
        self._ip_address = None
        self._port = None
        self._mysqlx_port = None

    @property
    def endpoint_type(self):
        """
        **[Required]** Gets the endpoint_type of this DbSystemEndpoint.
        The Type of Endpoint for the DbSystem.

        Allowed values for this property are: "READ_WRITE", "READ_ONLY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The endpoint_type of this DbSystemEndpoint.
        :rtype: str
        """
        return self._endpoint_type

    @endpoint_type.setter
    def endpoint_type(self, endpoint_type):
        """
        Sets the endpoint_type of this DbSystemEndpoint.
        The Type of Endpoint for the DbSystem.


        :param endpoint_type: The endpoint_type of this DbSystemEndpoint.
        :type: str
        """
        allowed_values = ["READ_WRITE", "READ_ONLY"]
        if not value_allowed_none_or_none_sentinel(endpoint_type, allowed_values):
            endpoint_type = 'UNKNOWN_ENUM_VALUE'
        self._endpoint_type = endpoint_type

    @property
    def ip_address(self):
        """
        **[Required]** Gets the ip_address of this DbSystemEndpoint.
        The IP address MySQLaaS instance is configured to listen on.


        :return: The ip_address of this DbSystemEndpoint.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this DbSystemEndpoint.
        The IP address MySQLaaS instance is configured to listen on.


        :param ip_address: The ip_address of this DbSystemEndpoint.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def port(self):
        """
        **[Required]** Gets the port of this DbSystemEndpoint.
        The port for MySQLaaS instance to listen on.


        :return: The port of this DbSystemEndpoint.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this DbSystemEndpoint.
        The port for MySQLaaS instance to listen on.


        :param port: The port of this DbSystemEndpoint.
        :type: int
        """
        self._port = port

    @property
    def mysqlx_port(self):
        """
        **[Required]** Gets the mysqlx_port of this DbSystemEndpoint.
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.


        :return: The mysqlx_port of this DbSystemEndpoint.
        :rtype: int
        """
        return self._mysqlx_port

    @mysqlx_port.setter
    def mysqlx_port(self, mysqlx_port):
        """
        Sets the mysqlx_port of this DbSystemEndpoint.
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.


        :param mysqlx_port: The mysqlx_port of this DbSystemEndpoint.
        :type: int
        """
        self._mysqlx_port = mysqlx_port

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
