# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InBoundChannel(object):
    """
    InBoundChannel model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InBoundChannel object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this InBoundChannel.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this InBoundChannel.
        :type compartment_id: str

        :param db_system_id:
            The value to assign to the db_system_id property of this InBoundChannel.
        :type db_system_id: str

        :param name:
            The value to assign to the name property of this InBoundChannel.
        :type name: str

        :param description:
            The value to assign to the description property of this InBoundChannel.
        :type description: str

        :param address:
            The value to assign to the address property of this InBoundChannel.
        :type address: str

        :param port:
            The value to assign to the port property of this InBoundChannel.
        :type port: int

        :param username:
            The value to assign to the username property of this InBoundChannel.
        :type username: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'db_system_id': 'str',
            'name': 'str',
            'description': 'str',
            'address': 'str',
            'port': 'int',
            'username': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'db_system_id': 'dbSystemId',
            'name': 'name',
            'description': 'description',
            'address': 'address',
            'port': 'port',
            'username': 'username'
        }

        self._id = None
        self._compartment_id = None
        self._db_system_id = None
        self._name = None
        self._description = None
        self._address = None
        self._port = None
        self._username = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this InBoundChannel.
        The OCID of the InBoundChannel used to receive data streams.


        :return: The id of this InBoundChannel.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this InBoundChannel.
        The OCID of the InBoundChannel used to receive data streams.


        :param id: The id of this InBoundChannel.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this InBoundChannel.
        The Oracle Cloud ID (OCID) of the compartment the DbSystem belongs in.


        :return: The compartment_id of this InBoundChannel.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this InBoundChannel.
        The Oracle Cloud ID (OCID) of the compartment the DbSystem belongs in.


        :param compartment_id: The compartment_id of this InBoundChannel.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def db_system_id(self):
        """
        **[Required]** Gets the db_system_id of this InBoundChannel.
        The OCID of the DbSystem the InBoundChannel is associated to.


        :return: The db_system_id of this InBoundChannel.
        :rtype: str
        """
        return self._db_system_id

    @db_system_id.setter
    def db_system_id(self, db_system_id):
        """
        Sets the db_system_id of this InBoundChannel.
        The OCID of the DbSystem the InBoundChannel is associated to.


        :param db_system_id: The db_system_id of this InBoundChannel.
        :type: str
        """
        self._db_system_id = db_system_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this InBoundChannel.
        Name that uniquely identifies the channel.


        :return: The name of this InBoundChannel.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this InBoundChannel.
        Name that uniquely identifies the channel.


        :param name: The name of this InBoundChannel.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this InBoundChannel.
        User-provided data about the in-bound channel.


        :return: The description of this InBoundChannel.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this InBoundChannel.
        User-provided data about the in-bound channel.


        :param description: The description of this InBoundChannel.
        :type: str
        """
        self._description = description

    @property
    def address(self):
        """
        **[Required]** Gets the address of this InBoundChannel.
        Address that a MySQLaaS instance or DbSystem shall connect to receive data changes.


        :return: The address of this InBoundChannel.
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address):
        """
        Sets the address of this InBoundChannel.
        Address that a MySQLaaS instance or DbSystem shall connect to receive data changes.


        :param address: The address of this InBoundChannel.
        :type: str
        """
        self._address = address

    @property
    def port(self):
        """
        Gets the port of this InBoundChannel.
        Port that a MySQLaaS instance or DbSystem shall connect to receive data changes. Default 3306.


        :return: The port of this InBoundChannel.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this InBoundChannel.
        Port that a MySQLaaS instance or DbSystem shall connect to receive data changes. Default 3306.


        :param port: The port of this InBoundChannel.
        :type: int
        """
        self._port = port

    @property
    def username(self):
        """
        **[Required]** Gets the username of this InBoundChannel.
        The user's name that MySQLaaS instance or DbSystemm shall use to connect to an entity to
        receive data changes.


        :return: The username of this InBoundChannel.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this InBoundChannel.
        The user's name that MySQLaaS instance or DbSystemm shall use to connect to an entity to
        receive data changes.


        :param username: The username of this InBoundChannel.
        :type: str
        """
        self._username = username

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
