# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Instance(object):
    """
    A MySQL-as-a-Service Instance.
    """

    #: A constant which can be used with the lifecycle_state property of a Instance.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a Instance.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Instance.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Instance.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a Instance.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a Instance.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a Instance.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new Instance object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Instance.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this Instance.
        :type compartment_id: str

        :param description:
            The value to assign to the description property of this Instance.
        :type description: str

        :param display_name:
            The value to assign to the display_name property of this Instance.
        :type display_name: str

        :param availability_domain:
            The value to assign to the availability_domain property of this Instance.
        :type availability_domain: str

        :param fault_domain:
            The value to assign to the fault_domain property of this Instance.
        :type fault_domain: str

        :param subnet_id:
            The value to assign to the subnet_id property of this Instance.
        :type subnet_id: str

        :param shape_name:
            The value to assign to the shape_name property of this Instance.
        :type shape_name: str

        :param admin_username:
            The value to assign to the admin_username property of this Instance.
        :type admin_username: str

        :param hostname:
            The value to assign to the hostname property of this Instance.
        :type hostname: str

        :param data_storage_size_in_gbs:
            The value to assign to the data_storage_size_in_gbs property of this Instance.
        :type data_storage_size_in_gbs: int

        :param ip_address:
            The value to assign to the ip_address property of this Instance.
        :type ip_address: str

        :param port:
            The value to assign to the port property of this Instance.
        :type port: int

        :param mysqlx_port:
            The value to assign to the mysqlx_port property of this Instance.
        :type mysqlx_port: int

        :param server_id:
            The value to assign to the server_id property of this Instance.
        :type server_id: int

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Instance.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this Instance.
        :type lifecycle_details: str

        :param mysql_version:
            The value to assign to the mysql_version property of this Instance.
        :type mysql_version: str

        :param configuration_id:
            The value to assign to the configuration_id property of this Instance.
        :type configuration_id: str

        :param time_created:
            The value to assign to the time_created property of this Instance.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this Instance.
        :type time_updated: datetime

        :param analytics_cluster:
            The value to assign to the analytics_cluster property of this Instance.
        :type analytics_cluster: AnalyticsCluster

        :param db_system:
            The value to assign to the db_system property of this Instance.
        :type db_system: InstanceDbSystemRole

        :param host_image_id:
            The value to assign to the host_image_id property of this Instance.
        :type host_image_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Instance.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Instance.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'description': 'str',
            'display_name': 'str',
            'availability_domain': 'str',
            'fault_domain': 'str',
            'subnet_id': 'str',
            'shape_name': 'str',
            'admin_username': 'str',
            'hostname': 'str',
            'data_storage_size_in_gbs': 'int',
            'ip_address': 'str',
            'port': 'int',
            'mysqlx_port': 'int',
            'server_id': 'int',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'mysql_version': 'str',
            'configuration_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'analytics_cluster': 'AnalyticsCluster',
            'db_system': 'InstanceDbSystemRole',
            'host_image_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'description': 'description',
            'display_name': 'displayName',
            'availability_domain': 'availabilityDomain',
            'fault_domain': 'faultDomain',
            'subnet_id': 'subnetId',
            'shape_name': 'shapeName',
            'admin_username': 'adminUsername',
            'hostname': 'hostname',
            'data_storage_size_in_gbs': 'dataStorageSizeInGBs',
            'ip_address': 'ipAddress',
            'port': 'port',
            'mysqlx_port': 'mysqlxPort',
            'server_id': 'serverId',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'mysql_version': 'mysqlVersion',
            'configuration_id': 'configurationId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'analytics_cluster': 'analyticsCluster',
            'db_system': 'dbSystem',
            'host_image_id': 'hostImageId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._compartment_id = None
        self._description = None
        self._display_name = None
        self._availability_domain = None
        self._fault_domain = None
        self._subnet_id = None
        self._shape_name = None
        self._admin_username = None
        self._hostname = None
        self._data_storage_size_in_gbs = None
        self._ip_address = None
        self._port = None
        self._mysqlx_port = None
        self._server_id = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._mysql_version = None
        self._configuration_id = None
        self._time_created = None
        self._time_updated = None
        self._analytics_cluster = None
        self._db_system = None
        self._host_image_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Instance.
        The OCID of the MySQLaaS instance.


        :return: The id of this Instance.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Instance.
        The OCID of the MySQLaaS instance.


        :param id: The id of this Instance.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this Instance.
        The OCID of the compartment.


        :return: The compartment_id of this Instance.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Instance.
        The OCID of the compartment.


        :param compartment_id: The compartment_id of this Instance.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def description(self):
        """
        Gets the description of this Instance.
        User-provided data about the MySQLaaS Instance.


        :return: The description of this Instance.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Instance.
        User-provided data about the MySQLaaS Instance.


        :param description: The description of this Instance.
        :type: str
        """
        self._description = description

    @property
    def display_name(self):
        """
        Gets the display_name of this Instance.
        The user-friendly name for the MySQLaaS instance. It does not have to be unique.


        :return: The display_name of this Instance.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Instance.
        The user-friendly name for the MySQLaaS instance. It does not have to be unique.


        :param display_name: The display_name of this Instance.
        :type: str
        """
        self._display_name = display_name

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this Instance.
        The name of the Availability Domain the MySQLaaS instance is located in.


        :return: The availability_domain of this Instance.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this Instance.
        The name of the Availability Domain the MySQLaaS instance is located in.


        :param availability_domain: The availability_domain of this Instance.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def fault_domain(self):
        """
        **[Required]** Gets the fault_domain of this Instance.
        The name of the Fault Domain the MySQLaaS instance is located in.


        :return: The fault_domain of this Instance.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this Instance.
        The name of the Fault Domain the MySQLaaS instance is located in.


        :param fault_domain: The fault_domain of this Instance.
        :type: str
        """
        self._fault_domain = fault_domain

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this Instance.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The OCID of the subnet the MySQLaaS instance is associated with.


        :return: The subnet_id of this Instance.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this Instance.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The OCID of the subnet the MySQLaaS instance is associated with.


        :param subnet_id: The subnet_id of this Instance.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def shape_name(self):
        """
        Gets the shape_name of this Instance.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The shape of the MySQLaaS instance. The shape determines resources
        to allocate to the MySQLaaS instance - CPU cores and memory for VM
        shapes; CPU cores, memory and storage for non-VM (or bare metal)
        shapes.


        :return: The shape_name of this Instance.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this Instance.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The shape of the MySQLaaS instance. The shape determines resources
        to allocate to the MySQLaaS instance - CPU cores and memory for VM
        shapes; CPU cores, memory and storage for non-VM (or bare metal)
        shapes.


        :param shape_name: The shape_name of this Instance.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def admin_username(self):
        """
        Gets the admin_username of this Instance.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The username for the administrative user for the MySQLaaS Instance.


        :return: The admin_username of this Instance.
        :rtype: str
        """
        return self._admin_username

    @admin_username.setter
    def admin_username(self, admin_username):
        """
        Sets the admin_username of this Instance.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The username for the administrative user for the MySQLaaS Instance.


        :param admin_username: The admin_username of this Instance.
        :type: str
        """
        self._admin_username = admin_username

    @property
    def hostname(self):
        """
        Gets the hostname of this Instance.
        The network host name for the MySQLaaS instance.


        :return: The hostname of this Instance.
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """
        Sets the hostname of this Instance.
        The network host name for the MySQLaaS instance.


        :param hostname: The hostname of this Instance.
        :type: str
        """
        self._hostname = hostname

    @property
    def data_storage_size_in_gbs(self):
        """
        Gets the data_storage_size_in_gbs of this Instance.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        Size of the data volume in GBs.


        :return: The data_storage_size_in_gbs of this Instance.
        :rtype: int
        """
        return self._data_storage_size_in_gbs

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, data_storage_size_in_gbs):
        """
        Sets the data_storage_size_in_gbs of this Instance.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        Size of the data volume in GBs.


        :param data_storage_size_in_gbs: The data_storage_size_in_gbs of this Instance.
        :type: int
        """
        self._data_storage_size_in_gbs = data_storage_size_in_gbs

    @property
    def ip_address(self):
        """
        Gets the ip_address of this Instance.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The IP address MySQLaaS instance is configured to listen on.


        :return: The ip_address of this Instance.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this Instance.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The IP address MySQLaaS instance is configured to listen on.


        :param ip_address: The ip_address of this Instance.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def port(self):
        """
        Gets the port of this Instance.
        The port MySQLaaS instance is configured to listen on.


        :return: The port of this Instance.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this Instance.
        The port MySQLaaS instance is configured to listen on.


        :param port: The port of this Instance.
        :type: int
        """
        self._port = port

    @property
    def mysqlx_port(self):
        """
        Gets the mysqlx_port of this Instance.
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.


        :return: The mysqlx_port of this Instance.
        :rtype: int
        """
        return self._mysqlx_port

    @mysqlx_port.setter
    def mysqlx_port(self, mysqlx_port):
        """
        Sets the mysqlx_port of this Instance.
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.


        :param mysqlx_port: The mysqlx_port of this Instance.
        :type: int
        """
        self._mysqlx_port = mysqlx_port

    @property
    def server_id(self):
        """
        Gets the server_id of this Instance.
        Value of the server_id parameter that should be unique to avoid issues with replication.


        :return: The server_id of this Instance.
        :rtype: int
        """
        return self._server_id

    @server_id.setter
    def server_id(self, server_id):
        """
        Sets the server_id of this Instance.
        Value of the server_id parameter that should be unique to avoid issues with replication.


        :param server_id: The server_id of this Instance.
        :type: int
        """
        self._server_id = server_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this Instance.
        The current state of the MySQLaaS instance.

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Instance.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Instance.
        The current state of the MySQLaaS instance.


        :param lifecycle_state: The lifecycle_state of this Instance.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this Instance.
        Additional information about the current lifecycleState.


        :return: The lifecycle_details of this Instance.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this Instance.
        Additional information about the current lifecycleState.


        :param lifecycle_details: The lifecycle_details of this Instance.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def mysql_version(self):
        """
        **[Required]** Gets the mysql_version of this Instance.
        The MySQL version used by the instance.


        :return: The mysql_version of this Instance.
        :rtype: str
        """
        return self._mysql_version

    @mysql_version.setter
    def mysql_version(self, mysql_version):
        """
        Sets the mysql_version of this Instance.
        The MySQL version used by the instance.


        :param mysql_version: The mysql_version of this Instance.
        :type: str
        """
        self._mysql_version = mysql_version

    @property
    def configuration_id(self):
        """
        Gets the configuration_id of this Instance.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        OCID of the MySQL Configuration associated with this instance.


        :return: The configuration_id of this Instance.
        :rtype: str
        """
        return self._configuration_id

    @configuration_id.setter
    def configuration_id(self, configuration_id):
        """
        Sets the configuration_id of this Instance.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        OCID of the MySQL Configuration associated with this instance.


        :param configuration_id: The configuration_id of this Instance.
        :type: str
        """
        self._configuration_id = configuration_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this Instance.
        The date and time the MySQLaaS instance was created, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this Instance.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Instance.
        The date and time the MySQLaaS instance was created, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this Instance.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this Instance.
        The date and time the MySQLaaS instance was last updated, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_updated of this Instance.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Instance.
        The date and time the MySQLaaS instance was last updated, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_updated: The time_updated of this Instance.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def analytics_cluster(self):
        """
        Gets the analytics_cluster of this Instance.

        :return: The analytics_cluster of this Instance.
        :rtype: AnalyticsCluster
        """
        return self._analytics_cluster

    @analytics_cluster.setter
    def analytics_cluster(self, analytics_cluster):
        """
        Sets the analytics_cluster of this Instance.

        :param analytics_cluster: The analytics_cluster of this Instance.
        :type: AnalyticsCluster
        """
        self._analytics_cluster = analytics_cluster

    @property
    def db_system(self):
        """
        **[Required]** Gets the db_system of this Instance.

        :return: The db_system of this Instance.
        :rtype: InstanceDbSystemRole
        """
        return self._db_system

    @db_system.setter
    def db_system(self, db_system):
        """
        Sets the db_system of this Instance.

        :param db_system: The db_system of this Instance.
        :type: InstanceDbSystemRole
        """
        self._db_system = db_system

    @property
    def host_image_id(self):
        """
        Gets the host_image_id of this Instance.
        [PRIVATE API] OCID of the host image for this Instance. If not set, the control plane default will be used.


        :return: The host_image_id of this Instance.
        :rtype: str
        """
        return self._host_image_id

    @host_image_id.setter
    def host_image_id(self, host_image_id):
        """
        Sets the host_image_id of this Instance.
        [PRIVATE API] OCID of the host image for this Instance. If not set, the control plane default will be used.


        :param host_image_id: The host_image_id of this Instance.
        :type: str
        """
        self._host_image_id = host_image_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this Instance.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this Instance.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Instance.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this Instance.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this Instance.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this Instance.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Instance.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this Instance.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
