# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstanceDbSystemRole(object):
    """
    Describes the Role the Instance fills in relation to the DbSystem
    """

    #: A constant which can be used with the role property of a InstanceDbSystemRole.
    #: This constant has a value of "STANDALONE"
    ROLE_STANDALONE = "STANDALONE"

    #: A constant which can be used with the role property of a InstanceDbSystemRole.
    #: This constant has a value of "PRIMARY"
    ROLE_PRIMARY = "PRIMARY"

    #: A constant which can be used with the role property of a InstanceDbSystemRole.
    #: This constant has a value of "SECONDARY"
    ROLE_SECONDARY = "SECONDARY"

    def __init__(self, **kwargs):
        """
        Initializes a new InstanceDbSystemRole object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param role:
            The value to assign to the role property of this InstanceDbSystemRole.
            Allowed values for this property are: "STANDALONE", "PRIMARY", "SECONDARY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type role: str

        :param id:
            The value to assign to the id property of this InstanceDbSystemRole.
        :type id: str

        """
        self.swagger_types = {
            'role': 'str',
            'id': 'str'
        }

        self.attribute_map = {
            'role': 'role',
            'id': 'id'
        }

        self._role = None
        self._id = None

    @property
    def role(self):
        """
        **[Required]** Gets the role of this InstanceDbSystemRole.
        Role played by this Instance in the DbSystem.

        Allowed values for this property are: "STANDALONE", "PRIMARY", "SECONDARY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The role of this InstanceDbSystemRole.
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """
        Sets the role of this InstanceDbSystemRole.
        Role played by this Instance in the DbSystem.


        :param role: The role of this InstanceDbSystemRole.
        :type: str
        """
        allowed_values = ["STANDALONE", "PRIMARY", "SECONDARY"]
        if not value_allowed_none_or_none_sentinel(role, allowed_values):
            role = 'UNKNOWN_ENUM_VALUE'
        self._role = role

    @property
    def id(self):
        """
        **[Required]** Gets the id of this InstanceDbSystemRole.
        The OCID of the DbSystem.


        :return: The id of this InstanceDbSystemRole.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this InstanceDbSystemRole.
        The OCID of the DbSystem.


        :param id: The id of this InstanceDbSystemRole.
        :type: str
        """
        self._id = id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
