# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstanceSummary(object):
    """
    MySQL-as-a-Service Instances Summary.
    """

    #: A constant which can be used with the lifecycle_state property of a InstanceSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a InstanceSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a InstanceSummary.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a InstanceSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a InstanceSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a InstanceSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a InstanceSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new InstanceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this InstanceSummary.
        :type id: str

        :param availability_domain:
            The value to assign to the availability_domain property of this InstanceSummary.
        :type availability_domain: str

        :param fault_domain:
            The value to assign to the fault_domain property of this InstanceSummary.
        :type fault_domain: str

        :param compartment_id:
            The value to assign to the compartment_id property of this InstanceSummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this InstanceSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this InstanceSummary.
        :type description: str

        :param shape_name:
            The value to assign to the shape_name property of this InstanceSummary.
        :type shape_name: str

        :param hostname:
            The value to assign to the hostname property of this InstanceSummary.
        :type hostname: str

        :param data_storage_size_in_gbs:
            The value to assign to the data_storage_size_in_gbs property of this InstanceSummary.
        :type data_storage_size_in_gbs: int

        :param ip_address:
            The value to assign to the ip_address property of this InstanceSummary.
        :type ip_address: str

        :param port:
            The value to assign to the port property of this InstanceSummary.
        :type port: int

        :param mysqlx_port:
            The value to assign to the mysqlx_port property of this InstanceSummary.
        :type mysqlx_port: int

        :param mysql_version:
            The value to assign to the mysql_version property of this InstanceSummary.
        :type mysql_version: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this InstanceSummary.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this InstanceSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this InstanceSummary.
        :type time_updated: datetime

        :param analytics_cluster:
            The value to assign to the analytics_cluster property of this InstanceSummary.
        :type analytics_cluster: AnalyticsClusterSummary

        :param db_system:
            The value to assign to the db_system property of this InstanceSummary.
        :type db_system: InstanceDbSystemRole

        :param freeform_tags:
            The value to assign to the freeform_tags property of this InstanceSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this InstanceSummary.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'availability_domain': 'str',
            'fault_domain': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'shape_name': 'str',
            'hostname': 'str',
            'data_storage_size_in_gbs': 'int',
            'ip_address': 'str',
            'port': 'int',
            'mysqlx_port': 'int',
            'mysql_version': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'analytics_cluster': 'AnalyticsClusterSummary',
            'db_system': 'InstanceDbSystemRole',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'id': 'id',
            'availability_domain': 'availabilityDomain',
            'fault_domain': 'faultDomain',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'shape_name': 'shapeName',
            'hostname': 'hostname',
            'data_storage_size_in_gbs': 'dataStorageSizeInGBs',
            'ip_address': 'ipAddress',
            'port': 'port',
            'mysqlx_port': 'mysqlxPort',
            'mysql_version': 'mysqlVersion',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'analytics_cluster': 'analyticsCluster',
            'db_system': 'dbSystem',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._id = None
        self._availability_domain = None
        self._fault_domain = None
        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._shape_name = None
        self._hostname = None
        self._data_storage_size_in_gbs = None
        self._ip_address = None
        self._port = None
        self._mysqlx_port = None
        self._mysql_version = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._analytics_cluster = None
        self._db_system = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this InstanceSummary.
        The OCID of the MySQLaaS instance.


        :return: The id of this InstanceSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this InstanceSummary.
        The OCID of the MySQLaaS instance.


        :param id: The id of this InstanceSummary.
        :type: str
        """
        self._id = id

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this InstanceSummary.
        The name of the Availability Domain the MySQLaaS instance is located in.


        :return: The availability_domain of this InstanceSummary.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this InstanceSummary.
        The name of the Availability Domain the MySQLaaS instance is located in.


        :param availability_domain: The availability_domain of this InstanceSummary.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def fault_domain(self):
        """
        Gets the fault_domain of this InstanceSummary.
        The name of the Fault Domain the MySQLaaS instance is located in.


        :return: The fault_domain of this InstanceSummary.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this InstanceSummary.
        The name of the Fault Domain the MySQLaaS instance is located in.


        :param fault_domain: The fault_domain of this InstanceSummary.
        :type: str
        """
        self._fault_domain = fault_domain

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this InstanceSummary.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The OCID of the compartment.


        :return: The compartment_id of this InstanceSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this InstanceSummary.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The OCID of the compartment.


        :param compartment_id: The compartment_id of this InstanceSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this InstanceSummary.
        The user-friendly name for the MySQLaaS instance. It does not have to be unique.


        :return: The display_name of this InstanceSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this InstanceSummary.
        The user-friendly name for the MySQLaaS instance. It does not have to be unique.


        :param display_name: The display_name of this InstanceSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this InstanceSummary.
        User-provided data about the MySQLaaS Instance.


        :return: The description of this InstanceSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this InstanceSummary.
        User-provided data about the MySQLaaS Instance.


        :param description: The description of this InstanceSummary.
        :type: str
        """
        self._description = description

    @property
    def shape_name(self):
        """
        **[Required]** Gets the shape_name of this InstanceSummary.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The shape of the MySQLaaS instance. The shape determines resources
        to allocate to the MySQLaaS instance - CPU cores and memory for VM
        shapes; CPU cores, memory and storage for non-VM (or bare metal)
        shapes.


        :return: The shape_name of this InstanceSummary.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this InstanceSummary.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The shape of the MySQLaaS instance. The shape determines resources
        to allocate to the MySQLaaS instance - CPU cores and memory for VM
        shapes; CPU cores, memory and storage for non-VM (or bare metal)
        shapes.


        :param shape_name: The shape_name of this InstanceSummary.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def hostname(self):
        """
        Gets the hostname of this InstanceSummary.
        The network host name for the MySQLaaS instance.


        :return: The hostname of this InstanceSummary.
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """
        Sets the hostname of this InstanceSummary.
        The network host name for the MySQLaaS instance.


        :param hostname: The hostname of this InstanceSummary.
        :type: str
        """
        self._hostname = hostname

    @property
    def data_storage_size_in_gbs(self):
        """
        **[Required]** Gets the data_storage_size_in_gbs of this InstanceSummary.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.
        Size of the data volume in GBs, defined in base-2, IEC units (GiBs).


        :return: The data_storage_size_in_gbs of this InstanceSummary.
        :rtype: int
        """
        return self._data_storage_size_in_gbs

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, data_storage_size_in_gbs):
        """
        Sets the data_storage_size_in_gbs of this InstanceSummary.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.
        Size of the data volume in GBs, defined in base-2, IEC units (GiBs).


        :param data_storage_size_in_gbs: The data_storage_size_in_gbs of this InstanceSummary.
        :type: int
        """
        self._data_storage_size_in_gbs = data_storage_size_in_gbs

    @property
    def ip_address(self):
        """
        Gets the ip_address of this InstanceSummary.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The IP address MySQLaaS instance is configured to listen on.


        :return: The ip_address of this InstanceSummary.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this InstanceSummary.
        DEPRECATED -- this field will be only available on DbSystem once implementation catches up.

        The IP address MySQLaaS instance is configured to listen on.


        :param ip_address: The ip_address of this InstanceSummary.
        :type: str
        """
        self._ip_address = ip_address

    @property
    def port(self):
        """
        **[Required]** Gets the port of this InstanceSummary.
        The port MySQLaaS instance is configured to listen on.


        :return: The port of this InstanceSummary.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this InstanceSummary.
        The port MySQLaaS instance is configured to listen on.


        :param port: The port of this InstanceSummary.
        :type: int
        """
        self._port = port

    @property
    def mysqlx_port(self):
        """
        Gets the mysqlx_port of this InstanceSummary.
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.


        :return: The mysqlx_port of this InstanceSummary.
        :rtype: int
        """
        return self._mysqlx_port

    @mysqlx_port.setter
    def mysqlx_port(self, mysqlx_port):
        """
        Sets the mysqlx_port of this InstanceSummary.
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.


        :param mysqlx_port: The mysqlx_port of this InstanceSummary.
        :type: int
        """
        self._mysqlx_port = mysqlx_port

    @property
    def mysql_version(self):
        """
        Gets the mysql_version of this InstanceSummary.
        The MySQL version used by the instance.


        :return: The mysql_version of this InstanceSummary.
        :rtype: str
        """
        return self._mysql_version

    @mysql_version.setter
    def mysql_version(self, mysql_version):
        """
        Sets the mysql_version of this InstanceSummary.
        The MySQL version used by the instance.


        :param mysql_version: The mysql_version of this InstanceSummary.
        :type: str
        """
        self._mysql_version = mysql_version

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this InstanceSummary.
        The current state of the MySQLaaS instance.

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this InstanceSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this InstanceSummary.
        The current state of the MySQLaaS instance.


        :param lifecycle_state: The lifecycle_state of this InstanceSummary.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this InstanceSummary.
        The date and time the MySQLaaS instance was created, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this InstanceSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this InstanceSummary.
        The date and time the MySQLaaS instance was created, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this InstanceSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this InstanceSummary.
        The date and time the MySQLaaS instance was last updated, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_updated of this InstanceSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this InstanceSummary.
        The date and time the MySQLaaS instance was last updated, as described by `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_updated: The time_updated of this InstanceSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def analytics_cluster(self):
        """
        Gets the analytics_cluster of this InstanceSummary.

        :return: The analytics_cluster of this InstanceSummary.
        :rtype: AnalyticsClusterSummary
        """
        return self._analytics_cluster

    @analytics_cluster.setter
    def analytics_cluster(self, analytics_cluster):
        """
        Sets the analytics_cluster of this InstanceSummary.

        :param analytics_cluster: The analytics_cluster of this InstanceSummary.
        :type: AnalyticsClusterSummary
        """
        self._analytics_cluster = analytics_cluster

    @property
    def db_system(self):
        """
        Gets the db_system of this InstanceSummary.

        :return: The db_system of this InstanceSummary.
        :rtype: InstanceDbSystemRole
        """
        return self._db_system

    @db_system.setter
    def db_system(self, db_system):
        """
        Sets the db_system of this InstanceSummary.

        :param db_system: The db_system of this InstanceSummary.
        :type: InstanceDbSystemRole
        """
        self._db_system = db_system

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this InstanceSummary.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this InstanceSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this InstanceSummary.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this InstanceSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this InstanceSummary.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this InstanceSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this InstanceSummary.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this InstanceSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
