# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MysqlaasInstanceLimitsCheck(object):
    """
    Describes the error if the check does not pass. Empty otherwise.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MysqlaasInstanceLimitsCheck object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param error_code:
            The value to assign to the error_code property of this MysqlaasInstanceLimitsCheck.
        :type error_code: str

        :param error_message:
            The value to assign to the error_message property of this MysqlaasInstanceLimitsCheck.
        :type error_message: str

        """
        self.swagger_types = {
            'error_code': 'str',
            'error_message': 'str'
        }

        self.attribute_map = {
            'error_code': 'errorCode',
            'error_message': 'errorMessage'
        }

        self._error_code = None
        self._error_message = None

    @property
    def error_code(self):
        """
        Gets the error_code of this MysqlaasInstanceLimitsCheck.
        In case of error this field will have the respective error code. Otherwise, it will be null.


        :return: The error_code of this MysqlaasInstanceLimitsCheck.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        """
        Sets the error_code of this MysqlaasInstanceLimitsCheck.
        In case of error this field will have the respective error code. Otherwise, it will be null.


        :param error_code: The error_code of this MysqlaasInstanceLimitsCheck.
        :type: str
        """
        self._error_code = error_code

    @property
    def error_message(self):
        """
        Gets the error_message of this MysqlaasInstanceLimitsCheck.
        In case of error this field will have the message describing the problem. Otherwise, it will be null.


        :return: The error_message of this MysqlaasInstanceLimitsCheck.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this MysqlaasInstanceLimitsCheck.
        In case of error this field will have the message describing the problem. Otherwise, it will be null.


        :param error_message: The error_message of this MysqlaasInstanceLimitsCheck.
        :type: str
        """
        self._error_message = error_message

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
