# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Option(object):
    """
    Option model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Option object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this Option.
        :type name: str

        :param value:
            The value to assign to the value property of this Option.
        :type value: str

        :param is_user_defined:
            The value to assign to the is_user_defined property of this Option.
        :type is_user_defined: bool

        """
        self.swagger_types = {
            'name': 'str',
            'value': 'str',
            'is_user_defined': 'bool'
        }

        self.attribute_map = {
            'name': 'name',
            'value': 'value',
            'is_user_defined': 'isUserDefined'
        }

        self._name = None
        self._value = None
        self._is_user_defined = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this Option.
        The option name.


        :return: The name of this Option.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Option.
        The option name.


        :param name: The name of this Option.
        :type: str
        """
        self._name = name

    @property
    def value(self):
        """
        **[Required]** Gets the value of this Option.
        The option actual value.


        :return: The value of this Option.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this Option.
        The option actual value.


        :param value: The value of this Option.
        :type: str
        """
        self._value = value

    @property
    def is_user_defined(self):
        """
        Gets the is_user_defined of this Option.
        Whether the option is explicitly defined by the user or by the system.


        :return: The is_user_defined of this Option.
        :rtype: bool
        """
        return self._is_user_defined

    @is_user_defined.setter
    def is_user_defined(self, is_user_defined):
        """
        Sets the is_user_defined of this Option.
        Whether the option is explicitly defined by the user or by the system.


        :param is_user_defined: The is_user_defined of this Option.
        :type: bool
        """
        self._is_user_defined = is_user_defined

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
