# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OptionMetadata(object):
    """
    OptionMetadata model.
    """

    #: A constant which can be used with the type property of a OptionMetadata.
    #: This constant has a value of "BOOLEAN"
    TYPE_BOOLEAN = "BOOLEAN"

    #: A constant which can be used with the type property of a OptionMetadata.
    #: This constant has a value of "STRING"
    TYPE_STRING = "STRING"

    #: A constant which can be used with the type property of a OptionMetadata.
    #: This constant has a value of "INTEGER"
    TYPE_INTEGER = "INTEGER"

    #: A constant which can be used with the type property of a OptionMetadata.
    #: This constant has a value of "NUMERIC"
    TYPE_NUMERIC = "NUMERIC"

    #: A constant which can be used with the type property of a OptionMetadata.
    #: This constant has a value of "ENUM"
    TYPE_ENUM = "ENUM"

    #: A constant which can be used with the type property of a OptionMetadata.
    #: This constant has a value of "SET"
    TYPE_SET = "SET"

    #: A constant which can be used with the type property of a OptionMetadata.
    #: This constant has a value of "FLAGSET"
    TYPE_FLAGSET = "FLAGSET"

    def __init__(self, **kwargs):
        """
        Initializes a new OptionMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this OptionMetadata.
        :type name: str

        :param type:
            The value to assign to the type property of this OptionMetadata.
            Allowed values for this property are: "BOOLEAN", "STRING", "INTEGER", "NUMERIC", "ENUM", "SET", "FLAGSET", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param default_value:
            The value to assign to the default_value property of this OptionMetadata.
        :type default_value: str

        :param is_configurable:
            The value to assign to the is_configurable property of this OptionMetadata.
        :type is_configurable: bool

        :param is_dynamic:
            The value to assign to the is_dynamic property of this OptionMetadata.
        :type is_dynamic: bool

        :param min:
            The value to assign to the min property of this OptionMetadata.
        :type min: float

        :param max:
            The value to assign to the max property of this OptionMetadata.
        :type max: float

        :param values:
            The value to assign to the values property of this OptionMetadata.
        :type values: list[OptionMetadataValue]

        :param description:
            The value to assign to the description property of this OptionMetadata.
        :type description: str

        """
        self.swagger_types = {
            'name': 'str',
            'type': 'str',
            'default_value': 'str',
            'is_configurable': 'bool',
            'is_dynamic': 'bool',
            'min': 'float',
            'max': 'float',
            'values': 'list[OptionMetadataValue]',
            'description': 'str'
        }

        self.attribute_map = {
            'name': 'name',
            'type': 'type',
            'default_value': 'defaultValue',
            'is_configurable': 'isConfigurable',
            'is_dynamic': 'isDynamic',
            'min': 'min',
            'max': 'max',
            'values': 'values',
            'description': 'description'
        }

        self._name = None
        self._type = None
        self._default_value = None
        self._is_configurable = None
        self._is_dynamic = None
        self._min = None
        self._max = None
        self._values = None
        self._description = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this OptionMetadata.
        The option's name.


        :return: The name of this OptionMetadata.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this OptionMetadata.
        The option's name.


        :param name: The name of this OptionMetadata.
        :type: str
        """
        self._name = name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this OptionMetadata.
        The data-type describing the range of values permissible for the option.

        Allowed values for this property are: "BOOLEAN", "STRING", "INTEGER", "NUMERIC", "ENUM", "SET", "FLAGSET", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this OptionMetadata.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this OptionMetadata.
        The data-type describing the range of values permissible for the option.


        :param type: The type of this OptionMetadata.
        :type: str
        """
        allowed_values = ["BOOLEAN", "STRING", "INTEGER", "NUMERIC", "ENUM", "SET", "FLAGSET"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def default_value(self):
        """
        Gets the default_value of this OptionMetadata.
        The option's default value.


        :return: The default_value of this OptionMetadata.
        :rtype: str
        """
        return self._default_value

    @default_value.setter
    def default_value(self, default_value):
        """
        Sets the default_value of this OptionMetadata.
        The option's default value.


        :param default_value: The default_value of this OptionMetadata.
        :type: str
        """
        self._default_value = default_value

    @property
    def is_configurable(self):
        """
        **[Required]** Gets the is_configurable of this OptionMetadata.
        Whether the option can be set by the user.


        :return: The is_configurable of this OptionMetadata.
        :rtype: bool
        """
        return self._is_configurable

    @is_configurable.setter
    def is_configurable(self, is_configurable):
        """
        Sets the is_configurable of this OptionMetadata.
        Whether the option can be set by the user.


        :param is_configurable: The is_configurable of this OptionMetadata.
        :type: bool
        """
        self._is_configurable = is_configurable

    @property
    def is_dynamic(self):
        """
        **[Required]** Gets the is_dynamic of this OptionMetadata.
        If true, the option is runtime settable and takes immediate effect, and can be used with `SET PERSIST`.
        If false, the option will only take effect on the next restart, and `SET PERSIST_ONLY` should be used.


        :return: The is_dynamic of this OptionMetadata.
        :rtype: bool
        """
        return self._is_dynamic

    @is_dynamic.setter
    def is_dynamic(self, is_dynamic):
        """
        Sets the is_dynamic of this OptionMetadata.
        If true, the option is runtime settable and takes immediate effect, and can be used with `SET PERSIST`.
        If false, the option will only take effect on the next restart, and `SET PERSIST_ONLY` should be used.


        :param is_dynamic: The is_dynamic of this OptionMetadata.
        :type: bool
        """
        self._is_dynamic = is_dynamic

    @property
    def min(self):
        """
        Gets the min of this OptionMetadata.
        Minimum value for INTEGER and NUMERIC, or length for STRING options.


        :return: The min of this OptionMetadata.
        :rtype: float
        """
        return self._min

    @min.setter
    def min(self, min):
        """
        Sets the min of this OptionMetadata.
        Minimum value for INTEGER and NUMERIC, or length for STRING options.


        :param min: The min of this OptionMetadata.
        :type: float
        """
        self._min = min

    @property
    def max(self):
        """
        Gets the max of this OptionMetadata.
        Maximum value for INTEGER and NUMERIC, or length for STRING options.


        :return: The max of this OptionMetadata.
        :rtype: float
        """
        return self._max

    @max.setter
    def max(self, max):
        """
        Sets the max of this OptionMetadata.
        Maximum value for INTEGER and NUMERIC, or length for STRING options.


        :param max: The max of this OptionMetadata.
        :type: float
        """
        self._max = max

    @property
    def values(self):
        """
        Gets the values of this OptionMetadata.
        In cases where an option has a defined/enumerated set of
        values, a description of the possible values.


        :return: The values of this OptionMetadata.
        :rtype: list[OptionMetadataValue]
        """
        return self._values

    @values.setter
    def values(self, values):
        """
        Sets the values of this OptionMetadata.
        In cases where an option has a defined/enumerated set of
        values, a description of the possible values.


        :param values: The values of this OptionMetadata.
        :type: list[OptionMetadataValue]
        """
        self._values = values

    @property
    def description(self):
        """
        Gets the description of this OptionMetadata.
        Additional information on how to configure the option


        :return: The description of this OptionMetadata.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this OptionMetadata.
        Additional information on how to configure the option


        :param description: The description of this OptionMetadata.
        :type: str
        """
        self._description = description

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
