# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OptionMetadataValue(object):
    """
    OptionMetadataValue model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OptionMetadataValue object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value:
            The value to assign to the value property of this OptionMetadataValue.
        :type value: str

        :param description:
            The value to assign to the description property of this OptionMetadataValue.
        :type description: str

        """
        self.swagger_types = {
            'value': 'str',
            'description': 'str'
        }

        self.attribute_map = {
            'value': 'value',
            'description': 'description'
        }

        self._value = None
        self._description = None

    @property
    def value(self):
        """
        Gets the value of this OptionMetadataValue.
        The literal value being described.


        :return: The value of this OptionMetadataValue.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this OptionMetadataValue.
        The literal value being described.


        :param value: The value of this OptionMetadataValue.
        :type: str
        """
        self._value = value

    @property
    def description(self):
        """
        Gets the description of this OptionMetadataValue.
        The semantics of the value being described.


        :return: The description of this OptionMetadataValue.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this OptionMetadataValue.
        The semantics of the value being described.


        :param description: The description of this OptionMetadataValue.
        :type: str
        """
        self._description = description

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
