# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateAnalyticsClusterDetails(object):
    """
    Details of the MySQLaaS Analytics Cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateAnalyticsClusterDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param description:
            The value to assign to the description property of this UpdateAnalyticsClusterDetails.
        :type description: str

        :param shape_name:
            The value to assign to the shape_name property of this UpdateAnalyticsClusterDetails.
        :type shape_name: str

        :param cluster_size:
            The value to assign to the cluster_size property of this UpdateAnalyticsClusterDetails.
        :type cluster_size: int

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateAnalyticsClusterDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateAnalyticsClusterDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'description': 'str',
            'shape_name': 'str',
            'cluster_size': 'int',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'description': 'description',
            'shape_name': 'shapeName',
            'cluster_size': 'clusterSize',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._description = None
        self._shape_name = None
        self._cluster_size = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def description(self):
        """
        Gets the description of this UpdateAnalyticsClusterDetails.
        User-provided data about the MySQLaaS Instance.


        :return: The description of this UpdateAnalyticsClusterDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateAnalyticsClusterDetails.
        User-provided data about the MySQLaaS Instance.


        :param description: The description of this UpdateAnalyticsClusterDetails.
        :type: str
        """
        self._description = description

    @property
    def shape_name(self):
        """
        Gets the shape_name of this UpdateAnalyticsClusterDetails.
        A change to the shape of the nodes in the Analytics Cluster will
        result in the entire cluster being torn down and re-created with
        Compute instances of the new Shape. This may result in significant
        downtime for the analytics capability while the Analytics Cluster is
        re-provisioned.


        :return: The shape_name of this UpdateAnalyticsClusterDetails.
        :rtype: str
        """
        return self._shape_name

    @shape_name.setter
    def shape_name(self, shape_name):
        """
        Sets the shape_name of this UpdateAnalyticsClusterDetails.
        A change to the shape of the nodes in the Analytics Cluster will
        result in the entire cluster being torn down and re-created with
        Compute instances of the new Shape. This may result in significant
        downtime for the analytics capability while the Analytics Cluster is
        re-provisioned.


        :param shape_name: The shape_name of this UpdateAnalyticsClusterDetails.
        :type: str
        """
        self._shape_name = shape_name

    @property
    def cluster_size(self):
        """
        Gets the cluster_size of this UpdateAnalyticsClusterDetails.
        A change to the number of nodes in the Analytics Cluster will result
        in the entire cluster being torn down and re-created with the new
        cluster of nodes. This may result in a significant downtime for the
        analytics capability while the Analytics Cluster is
        re-provisioned.


        :return: The cluster_size of this UpdateAnalyticsClusterDetails.
        :rtype: int
        """
        return self._cluster_size

    @cluster_size.setter
    def cluster_size(self, cluster_size):
        """
        Sets the cluster_size of this UpdateAnalyticsClusterDetails.
        A change to the number of nodes in the Analytics Cluster will result
        in the entire cluster being torn down and re-created with the new
        cluster of nodes. This may result in a significant downtime for the
        analytics capability while the Analytics Cluster is
        re-provisioned.


        :param cluster_size: The cluster_size of this UpdateAnalyticsClusterDetails.
        :type: int
        """
        self._cluster_size = cluster_size

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateAnalyticsClusterDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateAnalyticsClusterDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateAnalyticsClusterDetails.
        Simple key-value pair applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateAnalyticsClusterDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateAnalyticsClusterDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateAnalyticsClusterDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateAnalyticsClusterDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateAnalyticsClusterDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
