# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VersionOptionsMetadata(object):
    """
    Metadata about the collection of options valid for a specific MySQL version.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VersionOptionsMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param for_version:
            The value to assign to the for_version property of this VersionOptionsMetadata.
        :type for_version: str

        :param options:
            The value to assign to the options property of this VersionOptionsMetadata.
        :type options: list[OptionMetadata]

        """
        self.swagger_types = {
            'for_version': 'str',
            'options': 'list[OptionMetadata]'
        }

        self.attribute_map = {
            'for_version': 'forVersion',
            'options': 'options'
        }

        self._for_version = None
        self._options = None

    @property
    def for_version(self):
        """
        **[Required]** Gets the for_version of this VersionOptionsMetadata.
        The MySQL version for which the options are valid.


        :return: The for_version of this VersionOptionsMetadata.
        :rtype: str
        """
        return self._for_version

    @for_version.setter
    def for_version(self, for_version):
        """
        Sets the for_version of this VersionOptionsMetadata.
        The MySQL version for which the options are valid.


        :param for_version: The for_version of this VersionOptionsMetadata.
        :type: str
        """
        self._for_version = for_version

    @property
    def options(self):
        """
        **[Required]** Gets the options of this VersionOptionsMetadata.

        :return: The options of this VersionOptionsMetadata.
        :rtype: list[OptionMetadata]
        """
        return self._options

    @options.setter
    def options(self, options):
        """
        Sets the options of this VersionOptionsMetadata.

        :param options: The options of this VersionOptionsMetadata.
        :type: list[OptionMetadata]
        """
        self._options = options

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
