# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BucketOptionsDetails(object):
    """
    Internal options associated with a bucket.

    Arbitrary JSON keys and values associated with the bucket (for internal-use-only). Keys must be in
    \"opc-meta-*\" format.

    To use any of the API operations, you must be authorized in an IAM policy. If you are not authorized,
    talk to an administrator. If you are an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/Content/Identity/Concepts/policygetstarted.htm
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BucketOptionsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param freeform_options:
            The value to assign to the freeform_options property of this BucketOptionsDetails.
        :type freeform_options: object

        """
        self.swagger_types = {
            'freeform_options': 'object'
        }

        self.attribute_map = {
            'freeform_options': 'freeformOptions'
        }

        self._freeform_options = None

    @property
    def freeform_options(self):
        """
        **[Required]** Gets the freeform_options of this BucketOptionsDetails.

        :return: The freeform_options of this BucketOptionsDetails.
        :rtype: object
        """
        return self._freeform_options

    @freeform_options.setter
    def freeform_options(self, freeform_options):
        """
        Sets the freeform_options of this BucketOptionsDetails.

        :param freeform_options: The freeform_options of this BucketOptionsDetails.
        :type: object
        """
        self._freeform_options = freeform_options

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
