# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CopyPartDetails(object):
    """
    To use any of the API operations, you must be authorized in an IAM policy. If you are not authorized,
    talk to an administrator. If you are an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/Content/Identity/Concepts/policygetstarted.htm
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CopyPartDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_namespace:
            The value to assign to the source_namespace property of this CopyPartDetails.
        :type source_namespace: str

        :param source_bucket:
            The value to assign to the source_bucket property of this CopyPartDetails.
        :type source_bucket: str

        :param source_object:
            The value to assign to the source_object property of this CopyPartDetails.
        :type source_object: str

        :param range:
            The value to assign to the range property of this CopyPartDetails.
        :type range: str

        """
        self.swagger_types = {
            'source_namespace': 'str',
            'source_bucket': 'str',
            'source_object': 'str',
            'range': 'str'
        }

        self.attribute_map = {
            'source_namespace': 'sourceNamespace',
            'source_bucket': 'sourceBucket',
            'source_object': 'sourceObject',
            'range': 'range'
        }

        self._source_namespace = None
        self._source_bucket = None
        self._source_object = None
        self._range = None

    @property
    def source_namespace(self):
        """
        **[Required]** Gets the source_namespace of this CopyPartDetails.
        The Object Storage namespace of the object that will be copied from.


        :return: The source_namespace of this CopyPartDetails.
        :rtype: str
        """
        return self._source_namespace

    @source_namespace.setter
    def source_namespace(self, source_namespace):
        """
        Sets the source_namespace of this CopyPartDetails.
        The Object Storage namespace of the object that will be copied from.


        :param source_namespace: The source_namespace of this CopyPartDetails.
        :type: str
        """
        self._source_namespace = source_namespace

    @property
    def source_bucket(self):
        """
        **[Required]** Gets the source_bucket of this CopyPartDetails.
        The bucket of the object that will be copied from.


        :return: The source_bucket of this CopyPartDetails.
        :rtype: str
        """
        return self._source_bucket

    @source_bucket.setter
    def source_bucket(self, source_bucket):
        """
        Sets the source_bucket of this CopyPartDetails.
        The bucket of the object that will be copied from.


        :param source_bucket: The source_bucket of this CopyPartDetails.
        :type: str
        """
        self._source_bucket = source_bucket

    @property
    def source_object(self):
        """
        **[Required]** Gets the source_object of this CopyPartDetails.
        The name of the object that will be copied from.


        :return: The source_object of this CopyPartDetails.
        :rtype: str
        """
        return self._source_object

    @source_object.setter
    def source_object(self, source_object):
        """
        Sets the source_object of this CopyPartDetails.
        The name of the object that will be copied from.


        :param source_object: The source_object of this CopyPartDetails.
        :type: str
        """
        self._source_object = source_object

    @property
    def range(self):
        """
        Gets the range of this CopyPartDetails.
        Optional byte range to copy. Format is similar to standard range header as described in
        `RFC 7233`__. Note that only a single range of bytes
        is supported.

        __ https://tools.ietf.org/html/rfc7233#section-2.1


        :return: The range of this CopyPartDetails.
        :rtype: str
        """
        return self._range

    @range.setter
    def range(self, range):
        """
        Sets the range of this CopyPartDetails.
        Optional byte range to copy. Format is similar to standard range header as described in
        `RFC 7233`__. Note that only a single range of bytes
        is supported.

        __ https://tools.ietf.org/html/rfc7233#section-2.1


        :param range: The range of this CopyPartDetails.
        :type: str
        """
        self._range = range

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
