# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CopyPartETag(object):
    """
    CopyPartETag model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CopyPartETag object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param e_tag:
            The value to assign to the e_tag property of this CopyPartETag.
        :type e_tag: str

        """
        self.swagger_types = {
            'e_tag': 'str'
        }

        self.attribute_map = {
            'e_tag': 'ETag'
        }

        self._e_tag = None

    @property
    def e_tag(self):
        """
        **[Required]** Gets the e_tag of this CopyPartETag.
        The entity tag (ETag) of the new part.


        :return: The e_tag of this CopyPartETag.
        :rtype: str
        """
        return self._e_tag

    @e_tag.setter
    def e_tag(self, e_tag):
        """
        Sets the e_tag of this CopyPartETag.
        The entity tag (ETag) of the new part.


        :param e_tag: The e_tag of this CopyPartETag.
        :type: str
        """
        self._e_tag = e_tag

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
