# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MergeObjectMetadataDetails(object):
    """
    To merge Objects User metadata with existing metadata we specify the new metadata in the body.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MergeObjectMetadataDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metadata:
            The value to assign to the metadata property of this MergeObjectMetadataDetails.
        :type metadata: dict(str, str)

        """
        self.swagger_types = {
            'metadata': 'dict(str, str)'
        }

        self.attribute_map = {
            'metadata': 'metadata'
        }

        self._metadata = None

    @property
    def metadata(self):
        """
        **[Required]** Gets the metadata of this MergeObjectMetadataDetails.
        Arbitrary string keys-values pair for the user-defined metadata for the object to be merged with its current
        metadata. Keys must be in \"opc-meta-*\" format. Avoid entering confidential information.
        The size of user-defined metadata is measured by taking the sum of the number of bytes in the UTF-8 encoding
        of each key and value. The maximum metadata size after merge is 2975 bytes.


        :return: The metadata of this MergeObjectMetadataDetails.
        :rtype: dict(str, str)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this MergeObjectMetadataDetails.
        Arbitrary string keys-values pair for the user-defined metadata for the object to be merged with its current
        metadata. Keys must be in \"opc-meta-*\" format. Avoid entering confidential information.
        The size of user-defined metadata is measured by taking the sum of the number of bytes in the UTF-8 encoding
        of each key and value. The maximum metadata size after merge is 2975 bytes.


        :param metadata: The metadata of this MergeObjectMetadataDetails.
        :type: dict(str, str)
        """
        self._metadata = metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
