# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PostObjectMetadataResponse(object):
    """
    Updated object information after user-metadata update.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PostObjectMetadataResponse object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param e_tag:
            The value to assign to the e_tag property of this PostObjectMetadataResponse.
        :type e_tag: str

        :param time_modified:
            The value to assign to the time_modified property of this PostObjectMetadataResponse.
        :type time_modified: datetime

        """
        self.swagger_types = {
            'e_tag': 'str',
            'time_modified': 'datetime'
        }

        self.attribute_map = {
            'e_tag': 'ETag',
            'time_modified': 'timeModified'
        }

        self._e_tag = None
        self._time_modified = None

    @property
    def e_tag(self):
        """
        **[Required]** Gets the e_tag of this PostObjectMetadataResponse.
        The new entity tag (ETag) for the object.


        :return: The e_tag of this PostObjectMetadataResponse.
        :rtype: str
        """
        return self._e_tag

    @e_tag.setter
    def e_tag(self, e_tag):
        """
        Sets the e_tag of this PostObjectMetadataResponse.
        The new entity tag (ETag) for the object.


        :param e_tag: The e_tag of this PostObjectMetadataResponse.
        :type: str
        """
        self._e_tag = e_tag

    @property
    def time_modified(self):
        """
        **[Required]** Gets the time_modified of this PostObjectMetadataResponse.
        The time the object was modified, as described in `RFC 2616`__.

        __ https://tools.ietf.org/html/rfc2616#section-14.29


        :return: The time_modified of this PostObjectMetadataResponse.
        :rtype: datetime
        """
        return self._time_modified

    @time_modified.setter
    def time_modified(self, time_modified):
        """
        Sets the time_modified of this PostObjectMetadataResponse.
        The time the object was modified, as described in `RFC 2616`__.

        __ https://tools.ietf.org/html/rfc2616#section-14.29


        :param time_modified: The time_modified of this PostObjectMetadataResponse.
        :type: datetime
        """
        self._time_modified = time_modified

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
