# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from __future__ import absolute_import

from .change_log_group_compartment_details import ChangeLogGroupCompartmentDetails
from .change_log_log_group_details import ChangeLogLogGroupDetails
from .configuration import Configuration
from .create_log_details import CreateLogDetails
from .create_log_group_details import CreateLogGroupDetails
from .id import Id
from .indexing import Indexing
from .log import Log
from .log_group import LogGroup
from .log_group_summary import LogGroupSummary
from .log_summary import LogSummary
from .oci_service import OciService
from .source import Source
from .source_update_details import SourceUpdateDetails
from .update_configuration_details import UpdateConfigurationDetails
from .update_log_details import UpdateLogDetails
from .update_log_group_details import UpdateLogGroupDetails

# Maps type names to classes for public_logging services.
public_logging_type_mapping = {
    "ChangeLogGroupCompartmentDetails": ChangeLogGroupCompartmentDetails,
    "ChangeLogLogGroupDetails": ChangeLogLogGroupDetails,
    "Configuration": Configuration,
    "CreateLogDetails": CreateLogDetails,
    "CreateLogGroupDetails": CreateLogGroupDetails,
    "Id": Id,
    "Indexing": Indexing,
    "Log": Log,
    "LogGroup": LogGroup,
    "LogGroupSummary": LogGroupSummary,
    "LogSummary": LogSummary,
    "OciService": OciService,
    "Source": Source,
    "SourceUpdateDetails": SourceUpdateDetails,
    "UpdateConfigurationDetails": UpdateConfigurationDetails,
    "UpdateLogDetails": UpdateLogDetails,
    "UpdateLogGroupDetails": UpdateLogGroupDetails
}
