# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateConfigurationDetails(object):
    """
    The updateable configuration properties
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source:
            The value to assign to the source property of this UpdateConfigurationDetails.
        :type source: SourceUpdateDetails

        :param indexing:
            The value to assign to the indexing property of this UpdateConfigurationDetails.
        :type indexing: Indexing

        """
        self.swagger_types = {
            'source': 'SourceUpdateDetails',
            'indexing': 'Indexing'
        }

        self.attribute_map = {
            'source': 'source',
            'indexing': 'indexing'
        }

        self._source = None
        self._indexing = None

    @property
    def source(self):
        """
        **[Required]** Gets the source of this UpdateConfigurationDetails.

        :return: The source of this UpdateConfigurationDetails.
        :rtype: SourceUpdateDetails
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this UpdateConfigurationDetails.

        :param source: The source of this UpdateConfigurationDetails.
        :type: SourceUpdateDetails
        """
        self._source = source

    @property
    def indexing(self):
        """
        Gets the indexing of this UpdateConfigurationDetails.

        :return: The indexing of this UpdateConfigurationDetails.
        :rtype: Indexing
        """
        return self._indexing

    @indexing.setter
    def indexing(self, indexing):
        """
        Sets the indexing of this UpdateConfigurationDetails.

        :param indexing: The indexing of this UpdateConfigurationDetails.
        :type: Indexing
        """
        self._indexing = indexing

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
