# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.

from __future__ import absolute_import

from .change_storage_gateway_compartment_details import ChangeStorageGatewayCompartmentDetails
from .cloud_sync import CloudSync
from .cloud_sync_health import CloudSyncHealth
from .cloud_sync_summary import CloudSyncSummary
from .create_cloud_sync_details import CreateCloudSyncDetails
from .create_file_system_details import CreateFileSystemDetails
from .create_storage_gateway_details import CreateStorageGatewayDetails
from .file_system import FileSystem
from .file_system_health import FileSystemHealth
from .file_system_summary import FileSystemSummary
from .metrics import Metrics
from .metrics_cloudsync import MetricsCloudsync
from .metrics_filesystem import MetricsFilesystem
from .metrics_issues import MetricsIssues
from .metrics_issues_error import MetricsIssuesError
from .metrics_issues_rejectio import MetricsIssuesRejectio
from .metrics_issues_warn import MetricsIssuesWarn
from .metrics_resource import MetricsResource
from .metrics_resource_cache import MetricsResourceCache
from .metrics_resource_cloudsyncs import MetricsResourceCloudsyncs
from .metrics_resource_cpu import MetricsResourceCpu
from .metrics_resource_filesystems import MetricsResourceFilesystems
from .metrics_resource_log import MetricsResourceLog
from .metrics_resource_mem import MetricsResourceMem
from .metrics_resource_metadata import MetricsResourceMetadata
from .metrics_stats import MetricsStats
from .metrics_stats_cache import MetricsStatsCache
from .metrics_stats_cloudsyncs import MetricsStatsCloudsyncs
from .metrics_stats_cpu import MetricsStatsCpu
from .metrics_stats_data import MetricsStatsData
from .metrics_stats_filesystems import MetricsStatsFilesystems
from .metrics_stats_log import MetricsStatsLog
from .metrics_stats_mem import MetricsStatsMem
from .metrics_stats_metadata import MetricsStatsMetadata
from .status_reasons import StatusReasons
from .storage_gateway import StorageGateway
from .storage_gateway_health import StorageGatewayHealth
from .storage_gateway_summary import StorageGatewaySummary
from .update_cloud_sync_details import UpdateCloudSyncDetails
from .update_file_system_details import UpdateFileSystemDetails
from .update_storage_gateway_details import UpdateStorageGatewayDetails

# Maps type names to classes for storage_gateway services.
storage_gateway_type_mapping = {
    "ChangeStorageGatewayCompartmentDetails": ChangeStorageGatewayCompartmentDetails,
    "CloudSync": CloudSync,
    "CloudSyncHealth": CloudSyncHealth,
    "CloudSyncSummary": CloudSyncSummary,
    "CreateCloudSyncDetails": CreateCloudSyncDetails,
    "CreateFileSystemDetails": CreateFileSystemDetails,
    "CreateStorageGatewayDetails": CreateStorageGatewayDetails,
    "FileSystem": FileSystem,
    "FileSystemHealth": FileSystemHealth,
    "FileSystemSummary": FileSystemSummary,
    "Metrics": Metrics,
    "MetricsCloudsync": MetricsCloudsync,
    "MetricsFilesystem": MetricsFilesystem,
    "MetricsIssues": MetricsIssues,
    "MetricsIssuesError": MetricsIssuesError,
    "MetricsIssuesRejectio": MetricsIssuesRejectio,
    "MetricsIssuesWarn": MetricsIssuesWarn,
    "MetricsResource": MetricsResource,
    "MetricsResourceCache": MetricsResourceCache,
    "MetricsResourceCloudsyncs": MetricsResourceCloudsyncs,
    "MetricsResourceCpu": MetricsResourceCpu,
    "MetricsResourceFilesystems": MetricsResourceFilesystems,
    "MetricsResourceLog": MetricsResourceLog,
    "MetricsResourceMem": MetricsResourceMem,
    "MetricsResourceMetadata": MetricsResourceMetadata,
    "MetricsStats": MetricsStats,
    "MetricsStatsCache": MetricsStatsCache,
    "MetricsStatsCloudsyncs": MetricsStatsCloudsyncs,
    "MetricsStatsCpu": MetricsStatsCpu,
    "MetricsStatsData": MetricsStatsData,
    "MetricsStatsFilesystems": MetricsStatsFilesystems,
    "MetricsStatsLog": MetricsStatsLog,
    "MetricsStatsMem": MetricsStatsMem,
    "MetricsStatsMetadata": MetricsStatsMetadata,
    "StatusReasons": StatusReasons,
    "StorageGateway": StorageGateway,
    "StorageGatewayHealth": StorageGatewayHealth,
    "StorageGatewaySummary": StorageGatewaySummary,
    "UpdateCloudSyncDetails": UpdateCloudSyncDetails,
    "UpdateFileSystemDetails": UpdateFileSystemDetails,
    "UpdateStorageGatewayDetails": UpdateStorageGatewayDetails
}
