# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudSyncHealth(object):
    """
    The current health of the specified cloud sync.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CloudSyncHealth object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param reasons:
            The value to assign to the reasons property of this CloudSyncHealth.
        :type reasons: StatusReasons

        :param metrics:
            The value to assign to the metrics property of this CloudSyncHealth.
        :type metrics: MetricsCloudsync

        """
        self.swagger_types = {
            'reasons': 'StatusReasons',
            'metrics': 'MetricsCloudsync'
        }

        self.attribute_map = {
            'reasons': 'reasons',
            'metrics': 'metrics'
        }

        self._reasons = None
        self._metrics = None

    @property
    def reasons(self):
        """
        Gets the reasons of this CloudSyncHealth.
        Additional information about WARNING and CRITICAL health statuses.


        :return: The reasons of this CloudSyncHealth.
        :rtype: StatusReasons
        """
        return self._reasons

    @reasons.setter
    def reasons(self, reasons):
        """
        Sets the reasons of this CloudSyncHealth.
        Additional information about WARNING and CRITICAL health statuses.


        :param reasons: The reasons of this CloudSyncHealth.
        :type: StatusReasons
        """
        self._reasons = reasons

    @property
    def metrics(self):
        """
        **[Required]** Gets the metrics of this CloudSyncHealth.
        Metrics data about the specified cloud sync.


        :return: The metrics of this CloudSyncHealth.
        :rtype: MetricsCloudsync
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """
        Sets the metrics of this CloudSyncHealth.
        Metrics data about the specified cloud sync.


        :param metrics: The metrics of this CloudSyncHealth.
        :type: MetricsCloudsync
        """
        self._metrics = metrics

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
