# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudSyncSummary(object):
    """
    Summary view of the specified cloud sync.
    """

    #: A constant which can be used with the lifecycle_state property of a CloudSyncSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a CloudSyncSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a CloudSyncSummary.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a CloudSyncSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a CloudSyncSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new CloudSyncSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CloudSyncSummary.
        :type name: str

        :param id:
            The value to assign to the id property of this CloudSyncSummary.
        :type id: str

        :param source_path:
            The value to assign to the source_path property of this CloudSyncSummary.
        :type source_path: str

        :param target_path:
            The value to assign to the target_path property of this CloudSyncSummary.
        :type target_path: str

        :param is_upload:
            The value to assign to the is_upload property of this CloudSyncSummary.
        :type is_upload: bool

        :param is_auto_deletion_enabled:
            The value to assign to the is_auto_deletion_enabled property of this CloudSyncSummary.
        :type is_auto_deletion_enabled: bool

        :param files_from:
            The value to assign to the files_from property of this CloudSyncSummary.
        :type files_from: str

        :param error_count:
            The value to assign to the error_count property of this CloudSyncSummary.
        :type error_count: float

        :param warn_count:
            The value to assign to the warn_count property of this CloudSyncSummary.
        :type warn_count: float

        :param time_created:
            The value to assign to the time_created property of this CloudSyncSummary.
        :type time_created: datetime

        :param time_started:
            The value to assign to the time_started property of this CloudSyncSummary.
        :type time_started: datetime

        :param time_ended:
            The value to assign to the time_ended property of this CloudSyncSummary.
        :type time_ended: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this CloudSyncSummary.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this CloudSyncSummary.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CloudSyncSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CloudSyncSummary.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'name': 'str',
            'id': 'str',
            'source_path': 'str',
            'target_path': 'str',
            'is_upload': 'bool',
            'is_auto_deletion_enabled': 'bool',
            'files_from': 'str',
            'error_count': 'float',
            'warn_count': 'float',
            'time_created': 'datetime',
            'time_started': 'datetime',
            'time_ended': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'name': 'name',
            'id': 'id',
            'source_path': 'sourcePath',
            'target_path': 'targetPath',
            'is_upload': 'isUpload',
            'is_auto_deletion_enabled': 'isAutoDeletionEnabled',
            'files_from': 'filesFrom',
            'error_count': 'errorCount',
            'warn_count': 'warnCount',
            'time_created': 'timeCreated',
            'time_started': 'timeStarted',
            'time_ended': 'timeEnded',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._name = None
        self._id = None
        self._source_path = None
        self._target_path = None
        self._is_upload = None
        self._is_auto_deletion_enabled = None
        self._files_from = None
        self._error_count = None
        self._warn_count = None
        self._time_created = None
        self._time_started = None
        self._time_ended = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CloudSyncSummary.
        A unique cloud sync name from the specified storage gateway.

        Example: `cloud_sync_52019`


        :return: The name of this CloudSyncSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CloudSyncSummary.
        A unique cloud sync name from the specified storage gateway.

        Example: `cloud_sync_52019`


        :param name: The name of this CloudSyncSummary.
        :type: str
        """
        self._name = name

    @property
    def id(self):
        """
        **[Required]** Gets the id of this CloudSyncSummary.
        The `OCID`__ of the cloud sync.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this CloudSyncSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CloudSyncSummary.
        The `OCID`__ of the cloud sync.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this CloudSyncSummary.
        :type: str
        """
        self._id = id

    @property
    def source_path(self):
        """
        **[Required]** Gets the source_path of this CloudSyncSummary.
        The path to a source directory or file for the cloud sync.

        The path configuration depends on the direction of the cloud sync. To upload from an on-premises system to
        the cloud, the source path resembles the following:

        /cloudsync/mounts/<var>&lt;user_mount&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        To download from the cloud to an on-premises system, the source path resembles the following:

        <var>&lt;storage_gateway_file_system&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        **Note:** To configure a cloud sync, the file system on an on-premises storage gateway must be mounted under
        `/cloudsync/mounts`.


        :return: The source_path of this CloudSyncSummary.
        :rtype: str
        """
        return self._source_path

    @source_path.setter
    def source_path(self, source_path):
        """
        Sets the source_path of this CloudSyncSummary.
        The path to a source directory or file for the cloud sync.

        The path configuration depends on the direction of the cloud sync. To upload from an on-premises system to
        the cloud, the source path resembles the following:

        /cloudsync/mounts/<var>&lt;user_mount&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        To download from the cloud to an on-premises system, the source path resembles the following:

        <var>&lt;storage_gateway_file_system&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        **Note:** To configure a cloud sync, the file system on an on-premises storage gateway must be mounted under
        `/cloudsync/mounts`.


        :param source_path: The source_path of this CloudSyncSummary.
        :type: str
        """
        self._source_path = source_path

    @property
    def target_path(self):
        """
        **[Required]** Gets the target_path of this CloudSyncSummary.
        The path to a target directory or file for the cloud sync.

        The path configuration depends on the direction of the cloud sync. To upload from an on-premises system to
        the cloud, the target path resembles the following:

        <var>&lt;storage_gateway_file_system&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        To download from the cloud to an on-premises system, the target path resembles the following:

        /cloudsync/mounts/<var>&lt;user_mount&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        **Note:** To configure a cloud sync, the file system on an on-premises storage gateway must be mounted under
        `/cloudsync/mounts`.


        :return: The target_path of this CloudSyncSummary.
        :rtype: str
        """
        return self._target_path

    @target_path.setter
    def target_path(self, target_path):
        """
        Sets the target_path of this CloudSyncSummary.
        The path to a target directory or file for the cloud sync.

        The path configuration depends on the direction of the cloud sync. To upload from an on-premises system to
        the cloud, the target path resembles the following:

        <var>&lt;storage_gateway_file_system&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        To download from the cloud to an on-premises system, the target path resembles the following:

        /cloudsync/mounts/<var>&lt;user_mount&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        **Note:** To configure a cloud sync, the file system on an on-premises storage gateway must be mounted under
        `/cloudsync/mounts`.


        :param target_path: The target_path of this CloudSyncSummary.
        :type: str
        """
        self._target_path = target_path

    @property
    def is_upload(self):
        """
        **[Required]** Gets the is_upload of this CloudSyncSummary.
        Whether the cloud sync uploads data to the cloud. If \"true\", the cloud sync uploads data to the cloud.

        Example: `true`


        :return: The is_upload of this CloudSyncSummary.
        :rtype: bool
        """
        return self._is_upload

    @is_upload.setter
    def is_upload(self, is_upload):
        """
        Sets the is_upload of this CloudSyncSummary.
        Whether the cloud sync uploads data to the cloud. If \"true\", the cloud sync uploads data to the cloud.

        Example: `true`


        :param is_upload: The is_upload of this CloudSyncSummary.
        :type: bool
        """
        self._is_upload = is_upload

    @property
    def is_auto_deletion_enabled(self):
        """
        **[Required]** Gets the is_auto_deletion_enabled of this CloudSyncSummary.
        Whether the cloud sync automatically deletes files from the target when source files are renamed or deleted.
        If \"true\", the cloud sync automatically deletes files from the target.

        Example: `true`


        :return: The is_auto_deletion_enabled of this CloudSyncSummary.
        :rtype: bool
        """
        return self._is_auto_deletion_enabled

    @is_auto_deletion_enabled.setter
    def is_auto_deletion_enabled(self, is_auto_deletion_enabled):
        """
        Sets the is_auto_deletion_enabled of this CloudSyncSummary.
        Whether the cloud sync automatically deletes files from the target when source files are renamed or deleted.
        If \"true\", the cloud sync automatically deletes files from the target.

        Example: `true`


        :param is_auto_deletion_enabled: The is_auto_deletion_enabled of this CloudSyncSummary.
        :type: bool
        """
        self._is_auto_deletion_enabled = is_auto_deletion_enabled

    @property
    def files_from(self):
        """
        **[Required]** Gets the files_from of this CloudSyncSummary.
        The path to a file that lists a set of files to sync to the target. If you do not specify a file list, the
        service syncs all files. The list file should reside under the `/cloudsync/` directory on the machine running
        the storage gateway instance.

        Example: `/cloudsync/files.list`


        :return: The files_from of this CloudSyncSummary.
        :rtype: str
        """
        return self._files_from

    @files_from.setter
    def files_from(self, files_from):
        """
        Sets the files_from of this CloudSyncSummary.
        The path to a file that lists a set of files to sync to the target. If you do not specify a file list, the
        service syncs all files. The list file should reside under the `/cloudsync/` directory on the machine running
        the storage gateway instance.

        Example: `/cloudsync/files.list`


        :param files_from: The files_from of this CloudSyncSummary.
        :type: str
        """
        self._files_from = files_from

    @property
    def error_count(self):
        """
        **[Required]** Gets the error_count of this CloudSyncSummary.
        The number of errors returned by the cloud sync.

        Example: `1`


        :return: The error_count of this CloudSyncSummary.
        :rtype: float
        """
        return self._error_count

    @error_count.setter
    def error_count(self, error_count):
        """
        Sets the error_count of this CloudSyncSummary.
        The number of errors returned by the cloud sync.

        Example: `1`


        :param error_count: The error_count of this CloudSyncSummary.
        :type: float
        """
        self._error_count = error_count

    @property
    def warn_count(self):
        """
        **[Required]** Gets the warn_count of this CloudSyncSummary.
        The number of warnings returned by the cloud sync.

        Example: `3`


        :return: The warn_count of this CloudSyncSummary.
        :rtype: float
        """
        return self._warn_count

    @warn_count.setter
    def warn_count(self, warn_count):
        """
        Sets the warn_count of this CloudSyncSummary.
        The number of warnings returned by the cloud sync.

        Example: `3`


        :param warn_count: The warn_count of this CloudSyncSummary.
        :type: float
        """
        self._warn_count = warn_count

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this CloudSyncSummary.
        The date and time the cloud sync was created, in the format defined by RFC3339.

        Example: `2019-05-16T21:52:40.793Z`


        :return: The time_created of this CloudSyncSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this CloudSyncSummary.
        The date and time the cloud sync was created, in the format defined by RFC3339.

        Example: `2019-05-16T21:52:40.793Z`


        :param time_created: The time_created of this CloudSyncSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_started(self):
        """
        **[Required]** Gets the time_started of this CloudSyncSummary.
        The date and time the cloud sync started, in the format defined by RFC3339.

        Example: `2019-05-16T22:45:30.793Z`


        :return: The time_started of this CloudSyncSummary.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this CloudSyncSummary.
        The date and time the cloud sync started, in the format defined by RFC3339.

        Example: `2019-05-16T22:45:30.793Z`


        :param time_started: The time_started of this CloudSyncSummary.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_ended(self):
        """
        Gets the time_ended of this CloudSyncSummary.
        The date and time the cloud sync was completed, canceled, or failed, in the format defined by RFC3339.

        Example: `2019-05-16T23:30:30.793Z`


        :return: The time_ended of this CloudSyncSummary.
        :rtype: datetime
        """
        return self._time_ended

    @time_ended.setter
    def time_ended(self, time_ended):
        """
        Sets the time_ended of this CloudSyncSummary.
        The date and time the cloud sync was completed, canceled, or failed, in the format defined by RFC3339.

        Example: `2019-05-16T23:30:30.793Z`


        :param time_ended: The time_ended of this CloudSyncSummary.
        :type: datetime
        """
        self._time_ended = time_ended

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this CloudSyncSummary.
        The current lifecycle state of the cloud sync.

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this CloudSyncSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this CloudSyncSummary.
        The current lifecycle state of the cloud sync.


        :param lifecycle_state: The lifecycle_state of this CloudSyncSummary.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        **[Required]** Gets the lifecycle_details of this CloudSyncSummary.
        One of the following cloud sync-specific lifecycle substates:

        *  NONE
        *  CREATED
        *  RUN
        *  RUNNING
        *  COMPLETED
        *  FAILED
        *  CANCELING
        *  CANCELED
        *  UPDATING


        :return: The lifecycle_details of this CloudSyncSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this CloudSyncSummary.
        One of the following cloud sync-specific lifecycle substates:

        *  NONE
        *  CREATED
        *  RUN
        *  RUNNING
        *  COMPLETED
        *  FAILED
        *  CANCELING
        *  CANCELED
        *  UPDATING


        :param lifecycle_details: The lifecycle_details of this CloudSyncSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CloudSyncSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information,
        see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CloudSyncSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CloudSyncSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information,
        see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CloudSyncSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CloudSyncSummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CloudSyncSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CloudSyncSummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CloudSyncSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
