# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateCloudSyncDetails(object):
    """
    Configuration details for creating a cloud sync.

    **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateCloudSyncDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateCloudSyncDetails.
        :type name: str

        :param description:
            The value to assign to the description property of this CreateCloudSyncDetails.
        :type description: str

        :param source_path:
            The value to assign to the source_path property of this CreateCloudSyncDetails.
        :type source_path: str

        :param target_path:
            The value to assign to the target_path property of this CreateCloudSyncDetails.
        :type target_path: str

        :param is_auto_deletion_enabled:
            The value to assign to the is_auto_deletion_enabled property of this CreateCloudSyncDetails.
        :type is_auto_deletion_enabled: bool

        :param files_from:
            The value to assign to the files_from property of this CreateCloudSyncDetails.
        :type files_from: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateCloudSyncDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateCloudSyncDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'source_path': 'str',
            'target_path': 'str',
            'is_auto_deletion_enabled': 'bool',
            'files_from': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'source_path': 'sourcePath',
            'target_path': 'targetPath',
            'is_auto_deletion_enabled': 'isAutoDeletionEnabled',
            'files_from': 'filesFrom',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._name = None
        self._description = None
        self._source_path = None
        self._target_path = None
        self._is_auto_deletion_enabled = None
        self._files_from = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateCloudSyncDetails.
        A name for the cloud sync. It must be unique within the storage gateway, and it cannot be changed.

        Example: `cloud_sync_52019`


        :return: The name of this CreateCloudSyncDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateCloudSyncDetails.
        A name for the cloud sync. It must be unique within the storage gateway, and it cannot be changed.

        Example: `cloud_sync_52019`


        :param name: The name of this CreateCloudSyncDetails.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this CreateCloudSyncDetails.
        A description of the cloud sync. It does not have to be unique, and it is changeable.

        Example: `my first cloud sync`


        :return: The description of this CreateCloudSyncDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateCloudSyncDetails.
        A description of the cloud sync. It does not have to be unique, and it is changeable.

        Example: `my first cloud sync`


        :param description: The description of this CreateCloudSyncDetails.
        :type: str
        """
        self._description = description

    @property
    def source_path(self):
        """
        **[Required]** Gets the source_path of this CreateCloudSyncDetails.
        The path to a source directory or file for the cloud sync.

        The path configuration depends on the direction of the cloud sync. To upload from an on-premises system to
        the cloud, the source path resembles the following:

        /cloudsync/mounts/<var>&lt;user_mount&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        To download from the cloud to an on-premises system, the source path resembles the following:

        <var>&lt;storage_gateway_file_system&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        **Note:** To configure a cloud sync, the file system on an on-premises storage gateway must be mounted under
        `/cloudsync/mounts`.


        :return: The source_path of this CreateCloudSyncDetails.
        :rtype: str
        """
        return self._source_path

    @source_path.setter
    def source_path(self, source_path):
        """
        Sets the source_path of this CreateCloudSyncDetails.
        The path to a source directory or file for the cloud sync.

        The path configuration depends on the direction of the cloud sync. To upload from an on-premises system to
        the cloud, the source path resembles the following:

        /cloudsync/mounts/<var>&lt;user_mount&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        To download from the cloud to an on-premises system, the source path resembles the following:

        <var>&lt;storage_gateway_file_system&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        **Note:** To configure a cloud sync, the file system on an on-premises storage gateway must be mounted under
        `/cloudsync/mounts`.


        :param source_path: The source_path of this CreateCloudSyncDetails.
        :type: str
        """
        self._source_path = source_path

    @property
    def target_path(self):
        """
        **[Required]** Gets the target_path of this CreateCloudSyncDetails.
        The path to a target directory or file for the cloud sync.

        The path configuration depends on the direction of the cloud sync. To upload from an on-premises system to
        the cloud, the target path resembles the following:

        <var>&lt;storage_gateway_file_system&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        To download from the cloud to an on-premises system, the target path resembles the following:

        /cloudsync/mounts/<var>&lt;user_mount&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        **Note:** To configure a cloud sync, the file system on an on-premises storage gateway must be mounted under
        `/cloudsync/mounts`.


        :return: The target_path of this CreateCloudSyncDetails.
        :rtype: str
        """
        return self._target_path

    @target_path.setter
    def target_path(self, target_path):
        """
        Sets the target_path of this CreateCloudSyncDetails.
        The path to a target directory or file for the cloud sync.

        The path configuration depends on the direction of the cloud sync. To upload from an on-premises system to
        the cloud, the target path resembles the following:

        <var>&lt;storage_gateway_file_system&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        To download from the cloud to an on-premises system, the target path resembles the following:

        /cloudsync/mounts/<var>&lt;user_mount&gt;</var>/<var>&lt;path_to_directory&gt;</var>

        **Note:** To configure a cloud sync, the file system on an on-premises storage gateway must be mounted under
        `/cloudsync/mounts`.


        :param target_path: The target_path of this CreateCloudSyncDetails.
        :type: str
        """
        self._target_path = target_path

    @property
    def is_auto_deletion_enabled(self):
        """
        Gets the is_auto_deletion_enabled of this CreateCloudSyncDetails.
        Whether the cloud sync automatically deletes files from the target when source files are renamed or deleted.
        If \"true\", the cloud sync automatically deletes files from the target.

        Example: `true`


        :return: The is_auto_deletion_enabled of this CreateCloudSyncDetails.
        :rtype: bool
        """
        return self._is_auto_deletion_enabled

    @is_auto_deletion_enabled.setter
    def is_auto_deletion_enabled(self, is_auto_deletion_enabled):
        """
        Sets the is_auto_deletion_enabled of this CreateCloudSyncDetails.
        Whether the cloud sync automatically deletes files from the target when source files are renamed or deleted.
        If \"true\", the cloud sync automatically deletes files from the target.

        Example: `true`


        :param is_auto_deletion_enabled: The is_auto_deletion_enabled of this CreateCloudSyncDetails.
        :type: bool
        """
        self._is_auto_deletion_enabled = is_auto_deletion_enabled

    @property
    def files_from(self):
        """
        Gets the files_from of this CreateCloudSyncDetails.
        The path to a file that lists a set of files to sync to the target. If you do not specify a file list, the
        service syncs all files. The list file should reside under the `/cloudsync/` directory on the machine running
        the storage gateway instance.

        Example: `/cloudsync/files.list`


        :return: The files_from of this CreateCloudSyncDetails.
        :rtype: str
        """
        return self._files_from

    @files_from.setter
    def files_from(self, files_from):
        """
        Sets the files_from of this CreateCloudSyncDetails.
        The path to a file that lists a set of files to sync to the target. If you do not specify a file list, the
        service syncs all files. The list file should reside under the `/cloudsync/` directory on the machine running
        the storage gateway instance.

        Example: `/cloudsync/files.list`


        :param files_from: The files_from of this CreateCloudSyncDetails.
        :type: str
        """
        self._files_from = files_from

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateCloudSyncDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information,
        see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateCloudSyncDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateCloudSyncDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information,
        see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateCloudSyncDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateCloudSyncDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateCloudSyncDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateCloudSyncDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateCloudSyncDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
