# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateFileSystemDetails(object):
    """
    The configuration details for creating a storage gateway file system.

    **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
    """

    #: A constant which can be used with the storage_tier property of a CreateFileSystemDetails.
    #: This constant has a value of "STANDARD"
    STORAGE_TIER_STANDARD = "STANDARD"

    #: A constant which can be used with the storage_tier property of a CreateFileSystemDetails.
    #: This constant has a value of "ARCHIVE"
    STORAGE_TIER_ARCHIVE = "ARCHIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateFileSystemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateFileSystemDetails.
        :type name: str

        :param description:
            The value to assign to the description property of this CreateFileSystemDetails.
        :type description: str

        :param storage_tier:
            The value to assign to the storage_tier property of this CreateFileSystemDetails.
            Allowed values for this property are: "STANDARD", "ARCHIVE"
        :type storage_tier: str

        :param nfs_allowed_hosts:
            The value to assign to the nfs_allowed_hosts property of this CreateFileSystemDetails.
        :type nfs_allowed_hosts: str

        :param nfs_export_options:
            The value to assign to the nfs_export_options property of this CreateFileSystemDetails.
        :type nfs_export_options: str

        :param is_reclaim_attempt:
            The value to assign to the is_reclaim_attempt property of this CreateFileSystemDetails.
        :type is_reclaim_attempt: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateFileSystemDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateFileSystemDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'storage_tier': 'str',
            'nfs_allowed_hosts': 'str',
            'nfs_export_options': 'str',
            'is_reclaim_attempt': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'storage_tier': 'storageTier',
            'nfs_allowed_hosts': 'nfsAllowedHosts',
            'nfs_export_options': 'nfsExportOptions',
            'is_reclaim_attempt': 'isReclaimAttempt',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._name = None
        self._description = None
        self._storage_tier = None
        self._nfs_allowed_hosts = None
        self._nfs_export_options = None
        self._is_reclaim_attempt = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateFileSystemDetails.
        A name for the file system. It must be unique within your tenancy, and it cannot be changed. If an
        object storage bucket matching the file system name does not exist, it will be created.

        Example: `file_system_52019`


        :return: The name of this CreateFileSystemDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateFileSystemDetails.
        A name for the file system. It must be unique within your tenancy, and it cannot be changed. If an
        object storage bucket matching the file system name does not exist, it will be created.

        Example: `file_system_52019`


        :param name: The name of this CreateFileSystemDetails.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this CreateFileSystemDetails.
        A description of the storage gateway file system. It does not have to be unique, and it is changeable.

        Example: `my first storage gateway file system`


        :return: The description of this CreateFileSystemDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateFileSystemDetails.
        A description of the storage gateway file system. It does not have to be unique, and it is changeable.

        Example: `my first storage gateway file system`


        :param description: The description of this CreateFileSystemDetails.
        :type: str
        """
        self._description = description

    @property
    def storage_tier(self):
        """
        **[Required]** Gets the storage_tier of this CreateFileSystemDetails.
        The type of object storage tier used for data storage. The Standard tier is the default for data that
        requires frequent and fast access.

        Allowed values for this property are: "STANDARD", "ARCHIVE"


        :return: The storage_tier of this CreateFileSystemDetails.
        :rtype: str
        """
        return self._storage_tier

    @storage_tier.setter
    def storage_tier(self, storage_tier):
        """
        Sets the storage_tier of this CreateFileSystemDetails.
        The type of object storage tier used for data storage. The Standard tier is the default for data that
        requires frequent and fast access.


        :param storage_tier: The storage_tier of this CreateFileSystemDetails.
        :type: str
        """
        allowed_values = ["STANDARD", "ARCHIVE"]
        if not value_allowed_none_or_none_sentinel(storage_tier, allowed_values):
            raise ValueError(
                "Invalid value for `storage_tier`, must be None or one of {0}"
                .format(allowed_values)
            )
        self._storage_tier = storage_tier

    @property
    def nfs_allowed_hosts(self):
        """
        Gets the nfs_allowed_hosts of this CreateFileSystemDetails.
        A list of hosts allowed to connect to the NFS export. The list is comma-separated and whitespace is optional.
        Specify `*` to allow all hosts to connect.

        Example: `2001:db8:9:e54::/64, 192.168.2.0/24`


        :return: The nfs_allowed_hosts of this CreateFileSystemDetails.
        :rtype: str
        """
        return self._nfs_allowed_hosts

    @nfs_allowed_hosts.setter
    def nfs_allowed_hosts(self, nfs_allowed_hosts):
        """
        Sets the nfs_allowed_hosts of this CreateFileSystemDetails.
        A list of hosts allowed to connect to the NFS export. The list is comma-separated and whitespace is optional.
        Specify `*` to allow all hosts to connect.

        Example: `2001:db8:9:e54::/64, 192.168.2.0/24`


        :param nfs_allowed_hosts: The nfs_allowed_hosts of this CreateFileSystemDetails.
        :type: str
        """
        self._nfs_allowed_hosts = nfs_allowed_hosts

    @property
    def nfs_export_options(self):
        """
        Gets the nfs_export_options of this CreateFileSystemDetails.
        The NFS export options.

        Do not specify the `fsid` option.

        Example: `rw, sync, insecure, no_subtree_check, no_root_squash`


        :return: The nfs_export_options of this CreateFileSystemDetails.
        :rtype: str
        """
        return self._nfs_export_options

    @nfs_export_options.setter
    def nfs_export_options(self, nfs_export_options):
        """
        Sets the nfs_export_options of this CreateFileSystemDetails.
        The NFS export options.

        Do not specify the `fsid` option.

        Example: `rw, sync, insecure, no_subtree_check, no_root_squash`


        :param nfs_export_options: The nfs_export_options of this CreateFileSystemDetails.
        :type: str
        """
        self._nfs_export_options = nfs_export_options

    @property
    def is_reclaim_attempt(self):
        """
        Gets the is_reclaim_attempt of this CreateFileSystemDetails.
        Whether to reclaim an object storage bucket owned by another file system. When set to \"true\", the file system
        attempts to reclaim the bucket.

        Example: `true`


        :return: The is_reclaim_attempt of this CreateFileSystemDetails.
        :rtype: bool
        """
        return self._is_reclaim_attempt

    @is_reclaim_attempt.setter
    def is_reclaim_attempt(self, is_reclaim_attempt):
        """
        Sets the is_reclaim_attempt of this CreateFileSystemDetails.
        Whether to reclaim an object storage bucket owned by another file system. When set to \"true\", the file system
        attempts to reclaim the bucket.

        Example: `true`


        :param is_reclaim_attempt: The is_reclaim_attempt of this CreateFileSystemDetails.
        :type: bool
        """
        self._is_reclaim_attempt = is_reclaim_attempt

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateFileSystemDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information,
        see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateFileSystemDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateFileSystemDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information,
        see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateFileSystemDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateFileSystemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateFileSystemDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateFileSystemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateFileSystemDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
