# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FileSystem(object):
    """
    The configuration details of a file system. For general information about storage gateway file systems, see the
    \"How Storage Gateway Works\" section of
    `Overview of Storage Gateway`__.

    __ https://docs.cloud.oracle.com/iaas/Content/StorageGateway/Concepts/storagegatewayoverview.htm#howitworks
    """

    #: A constant which can be used with the storage_tier property of a FileSystem.
    #: This constant has a value of "STANDARD"
    STORAGE_TIER_STANDARD = "STANDARD"

    #: A constant which can be used with the storage_tier property of a FileSystem.
    #: This constant has a value of "ARCHIVE"
    STORAGE_TIER_ARCHIVE = "ARCHIVE"

    #: A constant which can be used with the lifecycle_state property of a FileSystem.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a FileSystem.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a FileSystem.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a FileSystem.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a FileSystem.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new FileSystem object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this FileSystem.
        :type compartment_id: str

        :param storage_gateway_id:
            The value to assign to the storage_gateway_id property of this FileSystem.
        :type storage_gateway_id: str

        :param name:
            The value to assign to the name property of this FileSystem.
        :type name: str

        :param id:
            The value to assign to the id property of this FileSystem.
        :type id: str

        :param description:
            The value to assign to the description property of this FileSystem.
        :type description: str

        :param storage_tier:
            The value to assign to the storage_tier property of this FileSystem.
            Allowed values for this property are: "STANDARD", "ARCHIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type storage_tier: str

        :param is_connected:
            The value to assign to the is_connected property of this FileSystem.
        :type is_connected: bool

        :param is_in_refresh_mode:
            The value to assign to the is_in_refresh_mode property of this FileSystem.
        :type is_in_refresh_mode: bool

        :param nfs_allowed_hosts:
            The value to assign to the nfs_allowed_hosts property of this FileSystem.
        :type nfs_allowed_hosts: str

        :param nfs_export_options:
            The value to assign to the nfs_export_options property of this FileSystem.
        :type nfs_export_options: str

        :param is_reclaim_attempt:
            The value to assign to the is_reclaim_attempt property of this FileSystem.
        :type is_reclaim_attempt: bool

        :param time_created:
            The value to assign to the time_created property of this FileSystem.
        :type time_created: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this FileSystem.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this FileSystem.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this FileSystem.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this FileSystem.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'storage_gateway_id': 'str',
            'name': 'str',
            'id': 'str',
            'description': 'str',
            'storage_tier': 'str',
            'is_connected': 'bool',
            'is_in_refresh_mode': 'bool',
            'nfs_allowed_hosts': 'str',
            'nfs_export_options': 'str',
            'is_reclaim_attempt': 'bool',
            'time_created': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'storage_gateway_id': 'storageGatewayId',
            'name': 'name',
            'id': 'id',
            'description': 'description',
            'storage_tier': 'storageTier',
            'is_connected': 'isConnected',
            'is_in_refresh_mode': 'isInRefreshMode',
            'nfs_allowed_hosts': 'nfsAllowedHosts',
            'nfs_export_options': 'nfsExportOptions',
            'is_reclaim_attempt': 'isReclaimAttempt',
            'time_created': 'timeCreated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._compartment_id = None
        self._storage_gateway_id = None
        self._name = None
        self._id = None
        self._description = None
        self._storage_tier = None
        self._is_connected = None
        self._is_in_refresh_mode = None
        self._nfs_allowed_hosts = None
        self._nfs_export_options = None
        self._is_reclaim_attempt = None
        self._time_created = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this FileSystem.
        The `OCID`__ of the compartment containing the storage gateway.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this FileSystem.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this FileSystem.
        The `OCID`__ of the compartment containing the storage gateway.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this FileSystem.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def storage_gateway_id(self):
        """
        **[Required]** Gets the storage_gateway_id of this FileSystem.
        The `OCID`__ of the compartment containing the file system.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The storage_gateway_id of this FileSystem.
        :rtype: str
        """
        return self._storage_gateway_id

    @storage_gateway_id.setter
    def storage_gateway_id(self, storage_gateway_id):
        """
        Sets the storage_gateway_id of this FileSystem.
        The `OCID`__ of the compartment containing the file system.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param storage_gateway_id: The storage_gateway_id of this FileSystem.
        :type: str
        """
        self._storage_gateway_id = storage_gateway_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this FileSystem.
        The name of the file system. It must be unique, and it cannot be changed.

        Example: `file_system_52019`


        :return: The name of this FileSystem.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FileSystem.
        The name of the file system. It must be unique, and it cannot be changed.

        Example: `file_system_52019`


        :param name: The name of this FileSystem.
        :type: str
        """
        self._name = name

    @property
    def id(self):
        """
        **[Required]** Gets the id of this FileSystem.
        The `OCID`__ of the file system.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this FileSystem.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FileSystem.
        The `OCID`__ of the file system.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this FileSystem.
        :type: str
        """
        self._id = id

    @property
    def description(self):
        """
        Gets the description of this FileSystem.
        A description of the file system. It does not have to be unique, and it can be changed.

         Example: `my first storage gateway file system`


        :return: The description of this FileSystem.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this FileSystem.
        A description of the file system. It does not have to be unique, and it can be changed.

         Example: `my first storage gateway file system`


        :param description: The description of this FileSystem.
        :type: str
        """
        self._description = description

    @property
    def storage_tier(self):
        """
        **[Required]** Gets the storage_tier of this FileSystem.
        The type of object storage tier used for data storage. The Standard tier is the default for data that
        requires frequent and fast access.

        Allowed values for this property are: "STANDARD", "ARCHIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The storage_tier of this FileSystem.
        :rtype: str
        """
        return self._storage_tier

    @storage_tier.setter
    def storage_tier(self, storage_tier):
        """
        Sets the storage_tier of this FileSystem.
        The type of object storage tier used for data storage. The Standard tier is the default for data that
        requires frequent and fast access.


        :param storage_tier: The storage_tier of this FileSystem.
        :type: str
        """
        allowed_values = ["STANDARD", "ARCHIVE"]
        if not value_allowed_none_or_none_sentinel(storage_tier, allowed_values):
            storage_tier = 'UNKNOWN_ENUM_VALUE'
        self._storage_tier = storage_tier

    @property
    def is_connected(self):
        """
        **[Required]** Gets the is_connected of this FileSystem.
        Whether the object storage bucket is connected. If \"true\", the object storage bucket is connected.

        Example: `true`


        :return: The is_connected of this FileSystem.
        :rtype: bool
        """
        return self._is_connected

    @is_connected.setter
    def is_connected(self, is_connected):
        """
        Sets the is_connected of this FileSystem.
        Whether the object storage bucket is connected. If \"true\", the object storage bucket is connected.

        Example: `true`


        :param is_connected: The is_connected of this FileSystem.
        :type: bool
        """
        self._is_connected = is_connected

    @property
    def is_in_refresh_mode(self):
        """
        **[Required]** Gets the is_in_refresh_mode of this FileSystem.
        Whether the file system is in refresh mode. If \"true\", the file system is in refresh mode.

        Example: `false`


        :return: The is_in_refresh_mode of this FileSystem.
        :rtype: bool
        """
        return self._is_in_refresh_mode

    @is_in_refresh_mode.setter
    def is_in_refresh_mode(self, is_in_refresh_mode):
        """
        Sets the is_in_refresh_mode of this FileSystem.
        Whether the file system is in refresh mode. If \"true\", the file system is in refresh mode.

        Example: `false`


        :param is_in_refresh_mode: The is_in_refresh_mode of this FileSystem.
        :type: bool
        """
        self._is_in_refresh_mode = is_in_refresh_mode

    @property
    def nfs_allowed_hosts(self):
        """
        **[Required]** Gets the nfs_allowed_hosts of this FileSystem.
        A list of hosts allowed to connect to the NFS export. The list is comma-separated and whitespace is optional.
        Specify `*` to allow all hosts to connect.

        Example: `2001:db8:9:e54::/64, 192.168.2.0/24`


        :return: The nfs_allowed_hosts of this FileSystem.
        :rtype: str
        """
        return self._nfs_allowed_hosts

    @nfs_allowed_hosts.setter
    def nfs_allowed_hosts(self, nfs_allowed_hosts):
        """
        Sets the nfs_allowed_hosts of this FileSystem.
        A list of hosts allowed to connect to the NFS export. The list is comma-separated and whitespace is optional.
        Specify `*` to allow all hosts to connect.

        Example: `2001:db8:9:e54::/64, 192.168.2.0/24`


        :param nfs_allowed_hosts: The nfs_allowed_hosts of this FileSystem.
        :type: str
        """
        self._nfs_allowed_hosts = nfs_allowed_hosts

    @property
    def nfs_export_options(self):
        """
        **[Required]** Gets the nfs_export_options of this FileSystem.
        The NFS export options.

        Do not specify the `fsid` option.

        Example: `rw, sync, insecure, no_subtree_check, no_root_squash`


        :return: The nfs_export_options of this FileSystem.
        :rtype: str
        """
        return self._nfs_export_options

    @nfs_export_options.setter
    def nfs_export_options(self, nfs_export_options):
        """
        Sets the nfs_export_options of this FileSystem.
        The NFS export options.

        Do not specify the `fsid` option.

        Example: `rw, sync, insecure, no_subtree_check, no_root_squash`


        :param nfs_export_options: The nfs_export_options of this FileSystem.
        :type: str
        """
        self._nfs_export_options = nfs_export_options

    @property
    def is_reclaim_attempt(self):
        """
        Gets the is_reclaim_attempt of this FileSystem.
        Whether to reclaim an object storage bucket owned by another file system. When set to \"true\", the file system
        attempts to reclaim the bucket.

        Example: `true`


        :return: The is_reclaim_attempt of this FileSystem.
        :rtype: bool
        """
        return self._is_reclaim_attempt

    @is_reclaim_attempt.setter
    def is_reclaim_attempt(self, is_reclaim_attempt):
        """
        Sets the is_reclaim_attempt of this FileSystem.
        Whether to reclaim an object storage bucket owned by another file system. When set to \"true\", the file system
        attempts to reclaim the bucket.

        Example: `true`


        :param is_reclaim_attempt: The is_reclaim_attempt of this FileSystem.
        :type: bool
        """
        self._is_reclaim_attempt = is_reclaim_attempt

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this FileSystem.
        The date and time the file system was created, in the format defined by RFC3339.

        Example: `2019-05-16T21:52:40.793Z`


        :return: The time_created of this FileSystem.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this FileSystem.
        The date and time the file system was created, in the format defined by RFC3339.

        Example: `2019-05-16T21:52:40.793Z`


        :param time_created: The time_created of this FileSystem.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this FileSystem.
        The current lifecycle state of the file system.

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this FileSystem.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this FileSystem.
        The current lifecycle state of the file system.


        :param lifecycle_state: The lifecycle_state of this FileSystem.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        **[Required]** Gets the lifecycle_details of this FileSystem.
        One of the following file system-specific lifecycle substates:

        *  `NONE`
        *  `CONNECTING`
        *  `DISCONNECTING`
        *  `RECLAIMING`
        *  `REFRESHING`
        *  `UPDATING`


        :return: The lifecycle_details of this FileSystem.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this FileSystem.
        One of the following file system-specific lifecycle substates:

        *  `NONE`
        *  `CONNECTING`
        *  `DISCONNECTING`
        *  `RECLAIMING`
        *  `REFRESHING`
        *  `UPDATING`


        :param lifecycle_details: The lifecycle_details of this FileSystem.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this FileSystem.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information,
        see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this FileSystem.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this FileSystem.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information,
        see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this FileSystem.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this FileSystem.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this FileSystem.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this FileSystem.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this FileSystem.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
