# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FileSystemHealth(object):
    """
    The current health of the specified file system.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FileSystemHealth object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param reasons:
            The value to assign to the reasons property of this FileSystemHealth.
        :type reasons: StatusReasons

        :param metrics:
            The value to assign to the metrics property of this FileSystemHealth.
        :type metrics: MetricsFilesystem

        """
        self.swagger_types = {
            'reasons': 'StatusReasons',
            'metrics': 'MetricsFilesystem'
        }

        self.attribute_map = {
            'reasons': 'reasons',
            'metrics': 'metrics'
        }

        self._reasons = None
        self._metrics = None

    @property
    def reasons(self):
        """
        Gets the reasons of this FileSystemHealth.
        Additional information about WARNING and CRITICAL health statuses.


        :return: The reasons of this FileSystemHealth.
        :rtype: StatusReasons
        """
        return self._reasons

    @reasons.setter
    def reasons(self, reasons):
        """
        Sets the reasons of this FileSystemHealth.
        Additional information about WARNING and CRITICAL health statuses.


        :param reasons: The reasons of this FileSystemHealth.
        :type: StatusReasons
        """
        self._reasons = reasons

    @property
    def metrics(self):
        """
        **[Required]** Gets the metrics of this FileSystemHealth.
        Metrics data about the specified file system.


        :return: The metrics of this FileSystemHealth.
        :rtype: MetricsFilesystem
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """
        Sets the metrics of this FileSystemHealth.
        Metrics data about the specified file system.


        :param metrics: The metrics of this FileSystemHealth.
        :type: MetricsFilesystem
        """
        self._metrics = metrics

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
