# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FileSystemSummary(object):
    """
    Summary view of the specified file system.
    """

    #: A constant which can be used with the storage_tier property of a FileSystemSummary.
    #: This constant has a value of "STANDARD"
    STORAGE_TIER_STANDARD = "STANDARD"

    #: A constant which can be used with the storage_tier property of a FileSystemSummary.
    #: This constant has a value of "ARCHIVE"
    STORAGE_TIER_ARCHIVE = "ARCHIVE"

    #: A constant which can be used with the lifecycle_state property of a FileSystemSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a FileSystemSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a FileSystemSummary.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a FileSystemSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a FileSystemSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new FileSystemSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this FileSystemSummary.
        :type name: str

        :param id:
            The value to assign to the id property of this FileSystemSummary.
        :type id: str

        :param storage_tier:
            The value to assign to the storage_tier property of this FileSystemSummary.
            Allowed values for this property are: "STANDARD", "ARCHIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type storage_tier: str

        :param is_connected:
            The value to assign to the is_connected property of this FileSystemSummary.
        :type is_connected: bool

        :param is_in_refresh_mode:
            The value to assign to the is_in_refresh_mode property of this FileSystemSummary.
        :type is_in_refresh_mode: bool

        :param error_count:
            The value to assign to the error_count property of this FileSystemSummary.
        :type error_count: float

        :param warn_count:
            The value to assign to the warn_count property of this FileSystemSummary.
        :type warn_count: float

        :param time_created:
            The value to assign to the time_created property of this FileSystemSummary.
        :type time_created: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this FileSystemSummary.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this FileSystemSummary.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this FileSystemSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this FileSystemSummary.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'name': 'str',
            'id': 'str',
            'storage_tier': 'str',
            'is_connected': 'bool',
            'is_in_refresh_mode': 'bool',
            'error_count': 'float',
            'warn_count': 'float',
            'time_created': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'name': 'name',
            'id': 'id',
            'storage_tier': 'storageTier',
            'is_connected': 'isConnected',
            'is_in_refresh_mode': 'isInRefreshMode',
            'error_count': 'errorCount',
            'warn_count': 'warnCount',
            'time_created': 'timeCreated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._name = None
        self._id = None
        self._storage_tier = None
        self._is_connected = None
        self._is_in_refresh_mode = None
        self._error_count = None
        self._warn_count = None
        self._time_created = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this FileSystemSummary.
        The file system name, which is unique within your tenancy.

        Example: `file_system_52019`


        :return: The name of this FileSystemSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FileSystemSummary.
        The file system name, which is unique within your tenancy.

        Example: `file_system_52019`


        :param name: The name of this FileSystemSummary.
        :type: str
        """
        self._name = name

    @property
    def id(self):
        """
        **[Required]** Gets the id of this FileSystemSummary.
        The `OCID`__ of the file system.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this FileSystemSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FileSystemSummary.
        The `OCID`__ of the file system.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this FileSystemSummary.
        :type: str
        """
        self._id = id

    @property
    def storage_tier(self):
        """
        **[Required]** Gets the storage_tier of this FileSystemSummary.
        The type of object storage tier used for data storage. The Standard tier is the default for data that
        requires frequent and fast access.

        Allowed values for this property are: "STANDARD", "ARCHIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The storage_tier of this FileSystemSummary.
        :rtype: str
        """
        return self._storage_tier

    @storage_tier.setter
    def storage_tier(self, storage_tier):
        """
        Sets the storage_tier of this FileSystemSummary.
        The type of object storage tier used for data storage. The Standard tier is the default for data that
        requires frequent and fast access.


        :param storage_tier: The storage_tier of this FileSystemSummary.
        :type: str
        """
        allowed_values = ["STANDARD", "ARCHIVE"]
        if not value_allowed_none_or_none_sentinel(storage_tier, allowed_values):
            storage_tier = 'UNKNOWN_ENUM_VALUE'
        self._storage_tier = storage_tier

    @property
    def is_connected(self):
        """
        **[Required]** Gets the is_connected of this FileSystemSummary.
        Whether the object storage bucket is connected. If \"true\", the object storage bucket is connected.

        Example: `true`


        :return: The is_connected of this FileSystemSummary.
        :rtype: bool
        """
        return self._is_connected

    @is_connected.setter
    def is_connected(self, is_connected):
        """
        Sets the is_connected of this FileSystemSummary.
        Whether the object storage bucket is connected. If \"true\", the object storage bucket is connected.

        Example: `true`


        :param is_connected: The is_connected of this FileSystemSummary.
        :type: bool
        """
        self._is_connected = is_connected

    @property
    def is_in_refresh_mode(self):
        """
        **[Required]** Gets the is_in_refresh_mode of this FileSystemSummary.
        Whether the file system is in refresh mode. If \"true\", the file system is in refresh mode.

        Example: `false`


        :return: The is_in_refresh_mode of this FileSystemSummary.
        :rtype: bool
        """
        return self._is_in_refresh_mode

    @is_in_refresh_mode.setter
    def is_in_refresh_mode(self, is_in_refresh_mode):
        """
        Sets the is_in_refresh_mode of this FileSystemSummary.
        Whether the file system is in refresh mode. If \"true\", the file system is in refresh mode.

        Example: `false`


        :param is_in_refresh_mode: The is_in_refresh_mode of this FileSystemSummary.
        :type: bool
        """
        self._is_in_refresh_mode = is_in_refresh_mode

    @property
    def error_count(self):
        """
        **[Required]** Gets the error_count of this FileSystemSummary.
        The number of errors returned by the file system.

        Example: `1`


        :return: The error_count of this FileSystemSummary.
        :rtype: float
        """
        return self._error_count

    @error_count.setter
    def error_count(self, error_count):
        """
        Sets the error_count of this FileSystemSummary.
        The number of errors returned by the file system.

        Example: `1`


        :param error_count: The error_count of this FileSystemSummary.
        :type: float
        """
        self._error_count = error_count

    @property
    def warn_count(self):
        """
        **[Required]** Gets the warn_count of this FileSystemSummary.
        The number of warnings returned by the file system.

        Example: `3`


        :return: The warn_count of this FileSystemSummary.
        :rtype: float
        """
        return self._warn_count

    @warn_count.setter
    def warn_count(self, warn_count):
        """
        Sets the warn_count of this FileSystemSummary.
        The number of warnings returned by the file system.

        Example: `3`


        :param warn_count: The warn_count of this FileSystemSummary.
        :type: float
        """
        self._warn_count = warn_count

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this FileSystemSummary.
        The date and time the file system was created, in the format defined by RFC3339.

        Example: `2019-05-16T21:52:40.793Z`


        :return: The time_created of this FileSystemSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this FileSystemSummary.
        The date and time the file system was created, in the format defined by RFC3339.

        Example: `2019-05-16T21:52:40.793Z`


        :param time_created: The time_created of this FileSystemSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this FileSystemSummary.
        The current lifecycle state of the file system. You cannot use the file system before the state is ACTIVE.
        When you disconnect a file system, its lifecycle state changes to INACTIVE.

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this FileSystemSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this FileSystemSummary.
        The current lifecycle state of the file system. You cannot use the file system before the state is ACTIVE.
        When you disconnect a file system, its lifecycle state changes to INACTIVE.


        :param lifecycle_state: The lifecycle_state of this FileSystemSummary.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        **[Required]** Gets the lifecycle_details of this FileSystemSummary.
        One of the following file system-specific lifecycle substates:

        *  `NONE`
        *  `CONNECTING`
        *  `DISCONNECTING`
        *  `RECLAIMING`
        *  `REFRESHING`
        *  `UPDATING`


        :return: The lifecycle_details of this FileSystemSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this FileSystemSummary.
        One of the following file system-specific lifecycle substates:

        *  `NONE`
        *  `CONNECTING`
        *  `DISCONNECTING`
        *  `RECLAIMING`
        *  `REFRESHING`
        *  `UPDATING`


        :param lifecycle_details: The lifecycle_details of this FileSystemSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this FileSystemSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information,
        see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this FileSystemSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this FileSystemSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information,
        see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this FileSystemSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this FileSystemSummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this FileSystemSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this FileSystemSummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this FileSystemSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
