# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Metrics(object):
    """
    The most current telemetry data posted from the specified storage gateway instance.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Metrics object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource:
            The value to assign to the resource property of this Metrics.
        :type resource: MetricsResource

        :param stats:
            The value to assign to the stats property of this Metrics.
        :type stats: MetricsStats

        :param issues:
            The value to assign to the issues property of this Metrics.
        :type issues: MetricsIssues

        :param filesystems:
            The value to assign to the filesystems property of this Metrics.
        :type filesystems: dict(str, MetricsFilesystem)

        :param cloudsyncs:
            The value to assign to the cloudsyncs property of this Metrics.
        :type cloudsyncs: dict(str, MetricsCloudsync)

        """
        self.swagger_types = {
            'resource': 'MetricsResource',
            'stats': 'MetricsStats',
            'issues': 'MetricsIssues',
            'filesystems': 'dict(str, MetricsFilesystem)',
            'cloudsyncs': 'dict(str, MetricsCloudsync)'
        }

        self.attribute_map = {
            'resource': 'resource',
            'stats': 'stats',
            'issues': 'issues',
            'filesystems': 'filesystems',
            'cloudsyncs': 'cloudsyncs'
        }

        self._resource = None
        self._stats = None
        self._issues = None
        self._filesystems = None
        self._cloudsyncs = None

    @property
    def resource(self):
        """
        Gets the resource of this Metrics.
        Provides metrics on storage gateway resource capacity, such as the number of vCPUs, memory size, and so forth.


        :return: The resource of this Metrics.
        :rtype: MetricsResource
        """
        return self._resource

    @resource.setter
    def resource(self, resource):
        """
        Sets the resource of this Metrics.
        Provides metrics on storage gateway resource capacity, such as the number of vCPUs, memory size, and so forth.


        :param resource: The resource of this Metrics.
        :type: MetricsResource
        """
        self._resource = resource

    @property
    def stats(self):
        """
        Gets the stats of this Metrics.
        Provides metrics on resource usage, such as CPU and memory utilization, created or connected file systems
        count, and so forth.


        :return: The stats of this Metrics.
        :rtype: MetricsStats
        """
        return self._stats

    @stats.setter
    def stats(self, stats):
        """
        Sets the stats of this Metrics.
        Provides metrics on resource usage, such as CPU and memory utilization, created or connected file systems
        count, and so forth.


        :param stats: The stats of this Metrics.
        :type: MetricsStats
        """
        self._stats = stats

    @property
    def issues(self):
        """
        Gets the issues of this Metrics.
        Provides metrics on errors, warnings, and rejected IO on the storage gateway.


        :return: The issues of this Metrics.
        :rtype: MetricsIssues
        """
        return self._issues

    @issues.setter
    def issues(self, issues):
        """
        Sets the issues of this Metrics.
        Provides metrics on errors, warnings, and rejected IO on the storage gateway.


        :param issues: The issues of this Metrics.
        :type: MetricsIssues
        """
        self._issues = issues

    @property
    def filesystems(self):
        """
        Gets the filesystems of this Metrics.
        Provides metrics on each of the file systems in the storage gateway. Each key represents a file system name.


        :return: The filesystems of this Metrics.
        :rtype: dict(str, MetricsFilesystem)
        """
        return self._filesystems

    @filesystems.setter
    def filesystems(self, filesystems):
        """
        Sets the filesystems of this Metrics.
        Provides metrics on each of the file systems in the storage gateway. Each key represents a file system name.


        :param filesystems: The filesystems of this Metrics.
        :type: dict(str, MetricsFilesystem)
        """
        self._filesystems = filesystems

    @property
    def cloudsyncs(self):
        """
        Gets the cloudsyncs of this Metrics.
        Provides metrics on each of the cloud syncs in the storage gateway. Each key represents a cloud sync name.


        :return: The cloudsyncs of this Metrics.
        :rtype: dict(str, MetricsCloudsync)
        """
        return self._cloudsyncs

    @cloudsyncs.setter
    def cloudsyncs(self, cloudsyncs):
        """
        Sets the cloudsyncs of this Metrics.
        Provides metrics on each of the cloud syncs in the storage gateway. Each key represents a cloud sync name.


        :param cloudsyncs: The cloudsyncs of this Metrics.
        :type: dict(str, MetricsCloudsync)
        """
        self._cloudsyncs = cloudsyncs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
