# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricsCloudsync(object):
    """
    cloud sync-specific metrics.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricsCloudsync object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param error_count:
            The value to assign to the error_count property of this MetricsCloudsync.
        :type error_count: float

        :param warn_count:
            The value to assign to the warn_count property of this MetricsCloudsync.
        :type warn_count: float

        :param cache_util_percent:
            The value to assign to the cache_util_percent property of this MetricsCloudsync.
        :type cache_util_percent: float

        :param cache_hit_percent:
            The value to assign to the cache_hit_percent property of this MetricsCloudsync.
        :type cache_hit_percent: float

        :param uploaded_data_in_bytes:
            The value to assign to the uploaded_data_in_bytes property of this MetricsCloudsync.
        :type uploaded_data_in_bytes: float

        :param downloaded_data_in_bytes:
            The value to assign to the downloaded_data_in_bytes property of this MetricsCloudsync.
        :type downloaded_data_in_bytes: float

        :param write_data_in_bytes:
            The value to assign to the write_data_in_bytes property of this MetricsCloudsync.
        :type write_data_in_bytes: float

        :param read_data_in_bytes:
            The value to assign to the read_data_in_bytes property of this MetricsCloudsync.
        :type read_data_in_bytes: float

        :param pending_data_in_bytes:
            The value to assign to the pending_data_in_bytes property of this MetricsCloudsync.
        :type pending_data_in_bytes: float

        :param source_data_in_bytes:
            The value to assign to the source_data_in_bytes property of this MetricsCloudsync.
        :type source_data_in_bytes: float

        """
        self.swagger_types = {
            'error_count': 'float',
            'warn_count': 'float',
            'cache_util_percent': 'float',
            'cache_hit_percent': 'float',
            'uploaded_data_in_bytes': 'float',
            'downloaded_data_in_bytes': 'float',
            'write_data_in_bytes': 'float',
            'read_data_in_bytes': 'float',
            'pending_data_in_bytes': 'float',
            'source_data_in_bytes': 'float'
        }

        self.attribute_map = {
            'error_count': 'errorCount',
            'warn_count': 'warnCount',
            'cache_util_percent': 'cacheUtilPercent',
            'cache_hit_percent': 'cacheHitPercent',
            'uploaded_data_in_bytes': 'uploadedDataInBytes',
            'downloaded_data_in_bytes': 'downloadedDataInBytes',
            'write_data_in_bytes': 'writeDataInBytes',
            'read_data_in_bytes': 'readDataInBytes',
            'pending_data_in_bytes': 'pendingDataInBytes',
            'source_data_in_bytes': 'sourceDataInBytes'
        }

        self._error_count = None
        self._warn_count = None
        self._cache_util_percent = None
        self._cache_hit_percent = None
        self._uploaded_data_in_bytes = None
        self._downloaded_data_in_bytes = None
        self._write_data_in_bytes = None
        self._read_data_in_bytes = None
        self._pending_data_in_bytes = None
        self._source_data_in_bytes = None

    @property
    def error_count(self):
        """
        Gets the error_count of this MetricsCloudsync.
        The total number of cloud sync errors.

        Example: `1`


        :return: The error_count of this MetricsCloudsync.
        :rtype: float
        """
        return self._error_count

    @error_count.setter
    def error_count(self, error_count):
        """
        Sets the error_count of this MetricsCloudsync.
        The total number of cloud sync errors.

        Example: `1`


        :param error_count: The error_count of this MetricsCloudsync.
        :type: float
        """
        self._error_count = error_count

    @property
    def warn_count(self):
        """
        Gets the warn_count of this MetricsCloudsync.
        The total number of cloud sync warnings.

        Example: `3`


        :return: The warn_count of this MetricsCloudsync.
        :rtype: float
        """
        return self._warn_count

    @warn_count.setter
    def warn_count(self, warn_count):
        """
        Sets the warn_count of this MetricsCloudsync.
        The total number of cloud sync warnings.

        Example: `3`


        :param warn_count: The warn_count of this MetricsCloudsync.
        :type: float
        """
        self._warn_count = warn_count

    @property
    def cache_util_percent(self):
        """
        Gets the cache_util_percent of this MetricsCloudsync.
        Cloud sync cache utilization (percent).

        Example: `45`


        :return: The cache_util_percent of this MetricsCloudsync.
        :rtype: float
        """
        return self._cache_util_percent

    @cache_util_percent.setter
    def cache_util_percent(self, cache_util_percent):
        """
        Sets the cache_util_percent of this MetricsCloudsync.
        Cloud sync cache utilization (percent).

        Example: `45`


        :param cache_util_percent: The cache_util_percent of this MetricsCloudsync.
        :type: float
        """
        self._cache_util_percent = cache_util_percent

    @property
    def cache_hit_percent(self):
        """
        Gets the cache_hit_percent of this MetricsCloudsync.
        Cloud sync cache hits (percent).

        Example: `80`


        :return: The cache_hit_percent of this MetricsCloudsync.
        :rtype: float
        """
        return self._cache_hit_percent

    @cache_hit_percent.setter
    def cache_hit_percent(self, cache_hit_percent):
        """
        Sets the cache_hit_percent of this MetricsCloudsync.
        Cloud sync cache hits (percent).

        Example: `80`


        :param cache_hit_percent: The cache_hit_percent of this MetricsCloudsync.
        :type: float
        """
        self._cache_hit_percent = cache_hit_percent

    @property
    def uploaded_data_in_bytes(self):
        """
        Gets the uploaded_data_in_bytes of this MetricsCloudsync.
        Uploaded cloud sync data in bytes.

        Example: `22369621334`


        :return: The uploaded_data_in_bytes of this MetricsCloudsync.
        :rtype: float
        """
        return self._uploaded_data_in_bytes

    @uploaded_data_in_bytes.setter
    def uploaded_data_in_bytes(self, uploaded_data_in_bytes):
        """
        Sets the uploaded_data_in_bytes of this MetricsCloudsync.
        Uploaded cloud sync data in bytes.

        Example: `22369621334`


        :param uploaded_data_in_bytes: The uploaded_data_in_bytes of this MetricsCloudsync.
        :type: float
        """
        self._uploaded_data_in_bytes = uploaded_data_in_bytes

    @property
    def downloaded_data_in_bytes(self):
        """
        Gets the downloaded_data_in_bytes of this MetricsCloudsync.
        Downloaded cloud sync data in bytes.

        Example: `13421772800`


        :return: The downloaded_data_in_bytes of this MetricsCloudsync.
        :rtype: float
        """
        return self._downloaded_data_in_bytes

    @downloaded_data_in_bytes.setter
    def downloaded_data_in_bytes(self, downloaded_data_in_bytes):
        """
        Sets the downloaded_data_in_bytes of this MetricsCloudsync.
        Downloaded cloud sync data in bytes.

        Example: `13421772800`


        :param downloaded_data_in_bytes: The downloaded_data_in_bytes of this MetricsCloudsync.
        :type: float
        """
        self._downloaded_data_in_bytes = downloaded_data_in_bytes

    @property
    def write_data_in_bytes(self):
        """
        Gets the write_data_in_bytes of this MetricsCloudsync.
        Cloud sync write (ingestion) data in bytes.

        Example: `8947848534`


        :return: The write_data_in_bytes of this MetricsCloudsync.
        :rtype: float
        """
        return self._write_data_in_bytes

    @write_data_in_bytes.setter
    def write_data_in_bytes(self, write_data_in_bytes):
        """
        Sets the write_data_in_bytes of this MetricsCloudsync.
        Cloud sync write (ingestion) data in bytes.

        Example: `8947848534`


        :param write_data_in_bytes: The write_data_in_bytes of this MetricsCloudsync.
        :type: float
        """
        self._write_data_in_bytes = write_data_in_bytes

    @property
    def read_data_in_bytes(self):
        """
        Gets the read_data_in_bytes of this MetricsCloudsync.
        Cloud sync read data in bytes.

        Example: `10737418240`


        :return: The read_data_in_bytes of this MetricsCloudsync.
        :rtype: float
        """
        return self._read_data_in_bytes

    @read_data_in_bytes.setter
    def read_data_in_bytes(self, read_data_in_bytes):
        """
        Sets the read_data_in_bytes of this MetricsCloudsync.
        Cloud sync read data in bytes.

        Example: `10737418240`


        :param read_data_in_bytes: The read_data_in_bytes of this MetricsCloudsync.
        :type: float
        """
        self._read_data_in_bytes = read_data_in_bytes

    @property
    def pending_data_in_bytes(self):
        """
        Gets the pending_data_in_bytes of this MetricsCloudsync.
        Cloud sync pending data in bytes.

        Example: `894784854`


        :return: The pending_data_in_bytes of this MetricsCloudsync.
        :rtype: float
        """
        return self._pending_data_in_bytes

    @pending_data_in_bytes.setter
    def pending_data_in_bytes(self, pending_data_in_bytes):
        """
        Sets the pending_data_in_bytes of this MetricsCloudsync.
        Cloud sync pending data in bytes.

        Example: `894784854`


        :param pending_data_in_bytes: The pending_data_in_bytes of this MetricsCloudsync.
        :type: float
        """
        self._pending_data_in_bytes = pending_data_in_bytes

    @property
    def source_data_in_bytes(self):
        """
        Gets the source_data_in_bytes of this MetricsCloudsync.
        Source data size in bytes.

        Example: `13421772800`


        :return: The source_data_in_bytes of this MetricsCloudsync.
        :rtype: float
        """
        return self._source_data_in_bytes

    @source_data_in_bytes.setter
    def source_data_in_bytes(self, source_data_in_bytes):
        """
        Sets the source_data_in_bytes of this MetricsCloudsync.
        Source data size in bytes.

        Example: `13421772800`


        :param source_data_in_bytes: The source_data_in_bytes of this MetricsCloudsync.
        :type: float
        """
        self._source_data_in_bytes = source_data_in_bytes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
