# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricsFilesystem(object):
    """
    File system-specific metrics.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricsFilesystem object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param error_count:
            The value to assign to the error_count property of this MetricsFilesystem.
        :type error_count: float

        :param warn_count:
            The value to assign to the warn_count property of this MetricsFilesystem.
        :type warn_count: float

        :param cache_util_percent:
            The value to assign to the cache_util_percent property of this MetricsFilesystem.
        :type cache_util_percent: float

        :param cache_hit_percent:
            The value to assign to the cache_hit_percent property of this MetricsFilesystem.
        :type cache_hit_percent: float

        :param uploaded_data_in_bytes:
            The value to assign to the uploaded_data_in_bytes property of this MetricsFilesystem.
        :type uploaded_data_in_bytes: float

        :param downloaded_data_in_bytes:
            The value to assign to the downloaded_data_in_bytes property of this MetricsFilesystem.
        :type downloaded_data_in_bytes: float

        :param write_data_in_bytes:
            The value to assign to the write_data_in_bytes property of this MetricsFilesystem.
        :type write_data_in_bytes: float

        :param read_data_in_bytes:
            The value to assign to the read_data_in_bytes property of this MetricsFilesystem.
        :type read_data_in_bytes: float

        :param pending_data_in_bytes:
            The value to assign to the pending_data_in_bytes property of this MetricsFilesystem.
        :type pending_data_in_bytes: float

        :param object_storage_usage_in_bytes:
            The value to assign to the object_storage_usage_in_bytes property of this MetricsFilesystem.
        :type object_storage_usage_in_bytes: float

        :param is_connected:
            The value to assign to the is_connected property of this MetricsFilesystem.
        :type is_connected: float

        :param is_in_refresh_mode:
            The value to assign to the is_in_refresh_mode property of this MetricsFilesystem.
        :type is_in_refresh_mode: float

        """
        self.swagger_types = {
            'error_count': 'float',
            'warn_count': 'float',
            'cache_util_percent': 'float',
            'cache_hit_percent': 'float',
            'uploaded_data_in_bytes': 'float',
            'downloaded_data_in_bytes': 'float',
            'write_data_in_bytes': 'float',
            'read_data_in_bytes': 'float',
            'pending_data_in_bytes': 'float',
            'object_storage_usage_in_bytes': 'float',
            'is_connected': 'float',
            'is_in_refresh_mode': 'float'
        }

        self.attribute_map = {
            'error_count': 'errorCount',
            'warn_count': 'warnCount',
            'cache_util_percent': 'cacheUtilPercent',
            'cache_hit_percent': 'cacheHitPercent',
            'uploaded_data_in_bytes': 'uploadedDataInBytes',
            'downloaded_data_in_bytes': 'downloadedDataInBytes',
            'write_data_in_bytes': 'writeDataInBytes',
            'read_data_in_bytes': 'readDataInBytes',
            'pending_data_in_bytes': 'pendingDataInBytes',
            'object_storage_usage_in_bytes': 'objectStorageUsageInBytes',
            'is_connected': 'isConnected',
            'is_in_refresh_mode': 'isInRefreshMode'
        }

        self._error_count = None
        self._warn_count = None
        self._cache_util_percent = None
        self._cache_hit_percent = None
        self._uploaded_data_in_bytes = None
        self._downloaded_data_in_bytes = None
        self._write_data_in_bytes = None
        self._read_data_in_bytes = None
        self._pending_data_in_bytes = None
        self._object_storage_usage_in_bytes = None
        self._is_connected = None
        self._is_in_refresh_mode = None

    @property
    def error_count(self):
        """
        Gets the error_count of this MetricsFilesystem.
        The total number of file system errors.

        Example: `1`


        :return: The error_count of this MetricsFilesystem.
        :rtype: float
        """
        return self._error_count

    @error_count.setter
    def error_count(self, error_count):
        """
        Sets the error_count of this MetricsFilesystem.
        The total number of file system errors.

        Example: `1`


        :param error_count: The error_count of this MetricsFilesystem.
        :type: float
        """
        self._error_count = error_count

    @property
    def warn_count(self):
        """
        Gets the warn_count of this MetricsFilesystem.
        The total number of file system warnings.

        Example: `3`


        :return: The warn_count of this MetricsFilesystem.
        :rtype: float
        """
        return self._warn_count

    @warn_count.setter
    def warn_count(self, warn_count):
        """
        Sets the warn_count of this MetricsFilesystem.
        The total number of file system warnings.

        Example: `3`


        :param warn_count: The warn_count of this MetricsFilesystem.
        :type: float
        """
        self._warn_count = warn_count

    @property
    def cache_util_percent(self):
        """
        Gets the cache_util_percent of this MetricsFilesystem.
        File system cache utilization (percent).

        Example: `45`


        :return: The cache_util_percent of this MetricsFilesystem.
        :rtype: float
        """
        return self._cache_util_percent

    @cache_util_percent.setter
    def cache_util_percent(self, cache_util_percent):
        """
        Sets the cache_util_percent of this MetricsFilesystem.
        File system cache utilization (percent).

        Example: `45`


        :param cache_util_percent: The cache_util_percent of this MetricsFilesystem.
        :type: float
        """
        self._cache_util_percent = cache_util_percent

    @property
    def cache_hit_percent(self):
        """
        Gets the cache_hit_percent of this MetricsFilesystem.
        File system cache hits (percent).

        Example: `80`


        :return: The cache_hit_percent of this MetricsFilesystem.
        :rtype: float
        """
        return self._cache_hit_percent

    @cache_hit_percent.setter
    def cache_hit_percent(self, cache_hit_percent):
        """
        Sets the cache_hit_percent of this MetricsFilesystem.
        File system cache hits (percent).

        Example: `80`


        :param cache_hit_percent: The cache_hit_percent of this MetricsFilesystem.
        :type: float
        """
        self._cache_hit_percent = cache_hit_percent

    @property
    def uploaded_data_in_bytes(self):
        """
        Gets the uploaded_data_in_bytes of this MetricsFilesystem.
        Uploaded file system data in bytes.

        Example: `44739242667`


        :return: The uploaded_data_in_bytes of this MetricsFilesystem.
        :rtype: float
        """
        return self._uploaded_data_in_bytes

    @uploaded_data_in_bytes.setter
    def uploaded_data_in_bytes(self, uploaded_data_in_bytes):
        """
        Sets the uploaded_data_in_bytes of this MetricsFilesystem.
        Uploaded file system data in bytes.

        Example: `44739242667`


        :param uploaded_data_in_bytes: The uploaded_data_in_bytes of this MetricsFilesystem.
        :type: float
        """
        self._uploaded_data_in_bytes = uploaded_data_in_bytes

    @property
    def downloaded_data_in_bytes(self):
        """
        Gets the downloaded_data_in_bytes of this MetricsFilesystem.
        Downloaded file system data in bytes.

        Example: `26843545600`


        :return: The downloaded_data_in_bytes of this MetricsFilesystem.
        :rtype: float
        """
        return self._downloaded_data_in_bytes

    @downloaded_data_in_bytes.setter
    def downloaded_data_in_bytes(self, downloaded_data_in_bytes):
        """
        Sets the downloaded_data_in_bytes of this MetricsFilesystem.
        Downloaded file system data in bytes.

        Example: `26843545600`


        :param downloaded_data_in_bytes: The downloaded_data_in_bytes of this MetricsFilesystem.
        :type: float
        """
        self._downloaded_data_in_bytes = downloaded_data_in_bytes

    @property
    def write_data_in_bytes(self):
        """
        Gets the write_data_in_bytes of this MetricsFilesystem.
        File system write (ingestion) data in bytes.

        Example: `17895697067`


        :return: The write_data_in_bytes of this MetricsFilesystem.
        :rtype: float
        """
        return self._write_data_in_bytes

    @write_data_in_bytes.setter
    def write_data_in_bytes(self, write_data_in_bytes):
        """
        Sets the write_data_in_bytes of this MetricsFilesystem.
        File system write (ingestion) data in bytes.

        Example: `17895697067`


        :param write_data_in_bytes: The write_data_in_bytes of this MetricsFilesystem.
        :type: float
        """
        self._write_data_in_bytes = write_data_in_bytes

    @property
    def read_data_in_bytes(self):
        """
        Gets the read_data_in_bytes of this MetricsFilesystem.
        File system read data in bytes.

        Example: `21474836480`


        :return: The read_data_in_bytes of this MetricsFilesystem.
        :rtype: float
        """
        return self._read_data_in_bytes

    @read_data_in_bytes.setter
    def read_data_in_bytes(self, read_data_in_bytes):
        """
        Sets the read_data_in_bytes of this MetricsFilesystem.
        File system read data in bytes.

        Example: `21474836480`


        :param read_data_in_bytes: The read_data_in_bytes of this MetricsFilesystem.
        :type: float
        """
        self._read_data_in_bytes = read_data_in_bytes

    @property
    def pending_data_in_bytes(self):
        """
        Gets the pending_data_in_bytes of this MetricsFilesystem.
        File system pending data in bytes.

        Example: `1789569707`


        :return: The pending_data_in_bytes of this MetricsFilesystem.
        :rtype: float
        """
        return self._pending_data_in_bytes

    @pending_data_in_bytes.setter
    def pending_data_in_bytes(self, pending_data_in_bytes):
        """
        Sets the pending_data_in_bytes of this MetricsFilesystem.
        File system pending data in bytes.

        Example: `1789569707`


        :param pending_data_in_bytes: The pending_data_in_bytes of this MetricsFilesystem.
        :type: float
        """
        self._pending_data_in_bytes = pending_data_in_bytes

    @property
    def object_storage_usage_in_bytes(self):
        """
        Gets the object_storage_usage_in_bytes of this MetricsFilesystem.
        File system object storage usage in bytes.


        :return: The object_storage_usage_in_bytes of this MetricsFilesystem.
        :rtype: float
        """
        return self._object_storage_usage_in_bytes

    @object_storage_usage_in_bytes.setter
    def object_storage_usage_in_bytes(self, object_storage_usage_in_bytes):
        """
        Sets the object_storage_usage_in_bytes of this MetricsFilesystem.
        File system object storage usage in bytes.


        :param object_storage_usage_in_bytes: The object_storage_usage_in_bytes of this MetricsFilesystem.
        :type: float
        """
        self._object_storage_usage_in_bytes = object_storage_usage_in_bytes

    @property
    def is_connected(self):
        """
        Gets the is_connected of this MetricsFilesystem.
        Zero if the file system is not connected.  Non-zero if the file system is connected.

        Example: `0`


        :return: The is_connected of this MetricsFilesystem.
        :rtype: float
        """
        return self._is_connected

    @is_connected.setter
    def is_connected(self, is_connected):
        """
        Sets the is_connected of this MetricsFilesystem.
        Zero if the file system is not connected.  Non-zero if the file system is connected.

        Example: `0`


        :param is_connected: The is_connected of this MetricsFilesystem.
        :type: float
        """
        self._is_connected = is_connected

    @property
    def is_in_refresh_mode(self):
        """
        Gets the is_in_refresh_mode of this MetricsFilesystem.
        Zero if the file system is not in refresh mode. Non-zero if the file system is in refresh mode.

        Example: `0`


        :return: The is_in_refresh_mode of this MetricsFilesystem.
        :rtype: float
        """
        return self._is_in_refresh_mode

    @is_in_refresh_mode.setter
    def is_in_refresh_mode(self, is_in_refresh_mode):
        """
        Sets the is_in_refresh_mode of this MetricsFilesystem.
        Zero if the file system is not in refresh mode. Non-zero if the file system is in refresh mode.

        Example: `0`


        :param is_in_refresh_mode: The is_in_refresh_mode of this MetricsFilesystem.
        :type: float
        """
        self._is_in_refresh_mode = is_in_refresh_mode

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
