# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricsIssues(object):
    """
    Metrics for errors, warnings, and input/output (IO) rejection issues.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricsIssues object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param error:
            The value to assign to the error property of this MetricsIssues.
        :type error: MetricsIssuesError

        :param warn:
            The value to assign to the warn property of this MetricsIssues.
        :type warn: MetricsIssuesWarn

        :param rejectio:
            The value to assign to the rejectio property of this MetricsIssues.
        :type rejectio: MetricsIssuesRejectio

        """
        self.swagger_types = {
            'error': 'MetricsIssuesError',
            'warn': 'MetricsIssuesWarn',
            'rejectio': 'MetricsIssuesRejectio'
        }

        self.attribute_map = {
            'error': 'error',
            'warn': 'warn',
            'rejectio': 'rejectio'
        }

        self._error = None
        self._warn = None
        self._rejectio = None

    @property
    def error(self):
        """
        Gets the error of this MetricsIssues.
        Error information.


        :return: The error of this MetricsIssues.
        :rtype: MetricsIssuesError
        """
        return self._error

    @error.setter
    def error(self, error):
        """
        Sets the error of this MetricsIssues.
        Error information.


        :param error: The error of this MetricsIssues.
        :type: MetricsIssuesError
        """
        self._error = error

    @property
    def warn(self):
        """
        Gets the warn of this MetricsIssues.
        Warning information.


        :return: The warn of this MetricsIssues.
        :rtype: MetricsIssuesWarn
        """
        return self._warn

    @warn.setter
    def warn(self, warn):
        """
        Sets the warn of this MetricsIssues.
        Warning information.


        :param warn: The warn of this MetricsIssues.
        :type: MetricsIssuesWarn
        """
        self._warn = warn

    @property
    def rejectio(self):
        """
        Gets the rejectio of this MetricsIssues.
        IO Rejection information.


        :return: The rejectio of this MetricsIssues.
        :rtype: MetricsIssuesRejectio
        """
        return self._rejectio

    @rejectio.setter
    def rejectio(self, rejectio):
        """
        Sets the rejectio of this MetricsIssues.
        IO Rejection information.


        :param rejectio: The rejectio of this MetricsIssues.
        :type: MetricsIssuesRejectio
        """
        self._rejectio = rejectio

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
