# coding: utf-8
# Copyright (c) 2016, 2019, Oracle and/or its affiliates. All rights reserved.


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricsIssuesError(object):
    """
    Error information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricsIssuesError object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param count:
            The value to assign to the count property of this MetricsIssuesError.
        :type count: float

        """
        self.swagger_types = {
            'count': 'float'
        }

        self.attribute_map = {
            'count': 'count'
        }

        self._count = None

    @property
    def count(self):
        """
        Gets the count of this MetricsIssuesError.
        Total number of errors found in the logs.

        Example: `2`


        :return: The count of this MetricsIssuesError.
        :rtype: float
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this MetricsIssuesError.
        Total number of errors found in the logs.

        Example: `2`


        :param count: The count of this MetricsIssuesError.
        :type: float
        """
        self._count = count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
